/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.store.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.InvalidScopeException;
import org.craftercms.core.exception.PathNotFoundException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.exception.XmlFileParseException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.store.impl.AbstractCachedContentStoreAdapter;
import org.craftercms.core.store.impl.File;
import org.craftercms.core.util.cache.impl.CachingAwareList;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.xml.sax.SAXException;

public abstract class AbstractFileBasedContentStoreAdapter
extends AbstractCachedContentStoreAdapter {
    public static final String DEFAULT_CHARSET = "UTF-8";
    protected String charset = "UTF-8";
    protected String descriptorFileExtension;
    protected String metadataFileExtension;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFileBasedContentStoreAdapter.class);

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Required
    public void setDescriptorFileExtension(String descriptorFileExtension) {
        this.descriptorFileExtension = descriptorFileExtension;
    }

    @Required
    public void setMetadataFileExtension(String metadataFileExtension) {
        this.metadataFileExtension = metadataFileExtension;
    }

    @Override
    public boolean exists(Context context, String path) throws InvalidScopeException, StoreException {
        return this.findFile(context, path) != null;
    }

    @Override
    protected Content doFindContent(Context context, CachingOptions cachingOptions, String path) throws InvalidContextException, StoreException {
        File file = this.findFile(context, path = this.normalizePath(path));
        if (file != null && !file.isFile()) {
            throw new StoreException("Unable to find content: " + file + " is not a file");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Item doFindItem(Context context, CachingOptions cachingOptions, String path, boolean withDescriptor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, StoreException {
        File file = this.findFile(context, path = this.normalizePath(path));
        if (file == null) {
            return null;
        }
        Item item = new Item();
        item.setName(file.getName());
        item.setUrl(path);
        item.setFolder(file.isDirectory());
        if (withDescriptor) {
            File descriptorFile;
            if (file.isFile() && item.getName().endsWith(this.descriptorFileExtension)) {
                item.setDescriptorUrl(path);
                descriptorFile = file;
            } else {
                String descriptorPath = FilenameUtils.removeExtension((String)path) + this.metadataFileExtension;
                item.setDescriptorUrl(descriptorPath);
                descriptorFile = this.findFile(context, descriptorPath);
                if (descriptorFile != null && !descriptorFile.isFile()) {
                    throw new StoreException("Descriptor file at " + descriptorFile + " is not really a file");
                }
            }
            if (descriptorFile != null) {
                try {
                    BufferedInputStream fileInputStream = new BufferedInputStream(descriptorFile.getInputStream());
                    InputStreamReader fileReader = new InputStreamReader((InputStream)fileInputStream, this.charset);
                    try {
                        item.setDescriptorDom(this.createXmlReader().read((Reader)fileReader));
                    }
                    finally {
                        IOUtils.closeQuietly((Reader)fileReader);
                    }
                }
                catch (IOException e) {
                    throw new StoreException("Unable to open input stream for descriptor file at " + descriptorFile, e);
                }
                catch (DocumentException e) {
                    throw new XmlFileParseException("Error while parsing xml document at " + descriptorFile, e);
                }
            }
        }
        return item;
    }

    @Override
    protected List<Item> doFindItems(Context context, CachingOptions cachingOptions, String path, boolean withDescriptor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, StoreException {
        File dir = this.findFile(context, path = this.normalizePath(path));
        if (dir == null) {
            return null;
        }
        if (!dir.isDirectory()) {
            throw new StoreException("The path " + dir + " doesn't correspond to a dir");
        }
        List<File> children = this.getChildren(context, dir);
        CachingAwareList<Item> items = new CachingAwareList<Item>(children.size());
        if (CollectionUtils.isNotEmpty(children)) {
            for (File child : children) {
                String fileRelPath;
                Item item;
                if (child.isFile() && child.getName().endsWith(this.metadataFileExtension) || (item = this.findItem(context, cachingOptions, fileRelPath = path + (!path.equals("/") ? "/" : "") + child.getName(), withDescriptor)) == null) continue;
                items.add(item);
                items.addDependencyKey(item.getKey());
            }
        }
        return items;
    }

    protected String normalizePath(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.equals("/")) {
            path = StringUtils.stripEnd((String)path, (String)"/");
        }
        return path;
    }

    protected SAXReader createXmlReader() {
        SAXReader xmlReader = new SAXReader();
        xmlReader.setMergeAdjacentText(true);
        xmlReader.setStripWhitespaceText(true);
        xmlReader.setIgnoreComments(true);
        try {
            xmlReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            xmlReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (SAXException ex) {
            LOGGER.error("Unable to turn off external entity loading, This could be a security risk.", (Throwable)ex);
        }
        try {
            xmlReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            xmlReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (SAXException ex) {
            LOGGER.error("Unable to turn off external entity loading, This could be a security risk.", (Throwable)ex);
        }
        return xmlReader;
    }

    protected abstract File findFile(Context var1, String var2) throws InvalidContextException, StoreException;

    protected abstract List<File> getChildren(Context var1, File var2) throws InvalidContextException, StoreException;
}

