/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.service.impl;

import java.util.List;
import org.craftercms.commons.lang.Callback;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.exception.PathNotFoundException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.exception.XmlFileParseException;
import org.craftercms.core.exception.XmlMergeException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.ItemFilter;
import org.craftercms.core.service.Tree;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.core.util.cache.impl.CachingAwareList;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractCachedContentStoreService
implements ContentStoreService {
    public static final String CONST_KEY_ELEM_ITEM = "contentStoreService.item";
    public static final String CONST_KEY_ELEM_CHILDREN = "contentStoreService.children";
    public static final String CONST_KEY_ELEM_TREE = "contentStoreService.tree";
    protected CacheTemplate cacheTemplate;
    protected CachingOptions defaultCachingOptions;

    @Required
    public void setCacheTemplate(CacheTemplate cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    public void setDefaultCachingOptions(CachingOptions defaultCachingOptions) {
        this.defaultCachingOptions = defaultCachingOptions;
    }

    @Override
    public Item findItem(Context context, String url) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.findItem(context, null, url, null);
    }

    @Override
    public Item findItem(final Context context, CachingOptions cachingOptions, final String url, final ItemProcessor processor) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        final CachingOptions actualCachingOptions = cachingOptions != null ? cachingOptions : this.defaultCachingOptions;
        return this.cacheTemplate.getObject(context, actualCachingOptions, new Callback<Item>(){

            public Item execute() {
                return AbstractCachedContentStoreService.this.doFindItem(context, actualCachingOptions, url, processor);
            }

            public String toString() {
                return String.format(AbstractCachedContentStoreService.this.getClass().getName() + ".getItem(%s, %s, %s)", context, url, processor);
            }
        }, context, url, processor, CONST_KEY_ELEM_ITEM);
    }

    @Override
    public Item getItem(Context context, String url) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getItem(context, null, url, null);
    }

    @Override
    public Item getItem(Context context, CachingOptions cachingOptions, String url, ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        Item item = this.findItem(context, cachingOptions, url, processor);
        if (item != null) {
            return item;
        }
        throw new PathNotFoundException("No item found at " + url);
    }

    @Override
    public List<Item> findChildren(Context context, String url) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.findChildren(context, null, url, null, null);
    }

    @Override
    public List<Item> findChildren(final Context context, CachingOptions cachingOptions, final String url, final ItemFilter filter, final ItemProcessor processor) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        final CachingOptions actualCachingOptions = cachingOptions != null ? cachingOptions : this.defaultCachingOptions;
        return this.cacheTemplate.getObject(context, actualCachingOptions, new Callback<List<Item>>(){

            public List<Item> execute() {
                List<Item> children = AbstractCachedContentStoreService.this.doFindChildren(context, actualCachingOptions, url, filter, processor);
                if (children != null) {
                    if (children instanceof CachingAwareList) {
                        return children;
                    }
                    return new CachingAwareList<Item>(children);
                }
                return null;
            }

            public String toString() {
                return String.format(AbstractCachedContentStoreService.this.getClass().getName() + ".getChildren(%s, %s, %s, %s)", context, url, filter, processor);
            }
        }, context, url, filter, processor, CONST_KEY_ELEM_CHILDREN);
    }

    @Override
    public List<Item> getChildren(Context context, String url) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getChildren(context, null, url, null, null);
    }

    @Override
    public List<Item> getChildren(Context context, CachingOptions cachingOptions, String url, ItemFilter filter, ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        List<Item> children = this.findChildren(context, cachingOptions, url, filter, processor);
        if (children != null) {
            return children;
        }
        throw new PathNotFoundException("No folder found at " + url);
    }

    @Override
    public Tree findTree(Context context, String url) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.findTree(context, null, url, -1, null, null);
    }

    @Override
    public Tree findTree(Context context, String url, int depth) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.findTree(context, null, url, depth, null, null);
    }

    @Override
    public Tree findTree(final Context context, CachingOptions cachingOptions, final String url, final int depth, final ItemFilter filter, final ItemProcessor processor) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        final CachingOptions actualCachingOptions = cachingOptions != null ? cachingOptions : this.defaultCachingOptions;
        return this.cacheTemplate.getObject(context, actualCachingOptions, new Callback<Tree>(){

            public Tree execute() {
                return AbstractCachedContentStoreService.this.doFindTree(context, actualCachingOptions, url, depth, filter, processor);
            }

            public String toString() {
                return String.format(AbstractCachedContentStoreService.this.getClass().getName() + ".getTree(%s, %s, %d, %s, %s)", context, url, depth, filter, processor);
            }
        }, context, url, depth, filter, processor, CONST_KEY_ELEM_TREE);
    }

    @Override
    public Tree getTree(Context context, String url) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getTree(context, null, url, -1, null, null);
    }

    @Override
    public Tree getTree(Context context, String url, int depth) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getTree(context, null, url, depth, null, null);
    }

    @Override
    public Tree getTree(Context context, CachingOptions cachingOptions, String url, int depth, ItemFilter filter, ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        Tree tree = this.findTree(context, cachingOptions, url, depth, filter, processor);
        if (tree != null) {
            return tree;
        }
        throw new PathNotFoundException("No folder found at " + url);
    }

    protected abstract Item doFindItem(Context var1, CachingOptions var2, String var3, ItemProcessor var4) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    protected abstract List<Item> doFindChildren(Context var1, CachingOptions var2, String var3, ItemFilter var4, ItemProcessor var5) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    protected abstract Tree doFindTree(Context var1, CachingOptions var2, String var3, int var4, ItemFilter var5, ItemProcessor var6) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;
}

