/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.core.util.XmlUtils;
import org.craftercms.core.util.cache.impl.CachingAwareObjectBase;
import org.dom4j.Document;
import org.dom4j.Node;

public class Item
extends CachingAwareObjectBase {
    protected String name;
    protected String url;
    protected String descriptorUrl;
    protected Document descriptorDom;
    protected Map<String, Object> properties;
    protected boolean isFolder;

    public Item() {
    }

    public Item(Item item) {
        this(item, true);
    }

    public Item(Item item, boolean deepCopy) {
        super(item, deepCopy);
        this.name = item.name;
        this.url = item.url;
        this.descriptorUrl = item.descriptorUrl;
        this.isFolder = item.isFolder;
        if (deepCopy) {
            this.descriptorDom = item.descriptorDom != null ? (Document)item.descriptorDom.clone() : null;
            this.properties = item.properties != null ? new HashMap<String, Object>(item.properties) : null;
        } else {
            this.descriptorDom = item.descriptorDom;
            this.properties = item.properties;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDescriptorUrl() {
        return this.descriptorUrl;
    }

    public void setDescriptorUrl(String descriptorUrl) {
        this.descriptorUrl = descriptorUrl;
    }

    public Document getDescriptorDom() {
        return this.descriptorDom;
    }

    public void setDescriptorDom(Document descriptorDom) {
        this.descriptorDom = descriptorDom;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Object getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(key, value);
    }

    public String queryDescriptorValue(String xpathQuery) {
        if (this.descriptorDom != null) {
            String value = (String)this.getProperty(xpathQuery);
            if (value == null) {
                value = XmlUtils.selectSingleNodeValue((Node)this.descriptorDom, xpathQuery);
            }
            return value;
        }
        return null;
    }

    public List<String> queryDescriptorValues(String xpathQuery) {
        if (this.descriptorDom != null) {
            List<String> value = (List<String>)this.getProperty(xpathQuery);
            if (CollectionUtils.isEmpty((Collection)value)) {
                value = XmlUtils.selectNodeValues((Node)this.descriptorDom, xpathQuery);
            }
            return value;
        }
        return Collections.emptyList();
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public void setFolder(boolean folder) {
        this.isFolder = folder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item)o;
        if (this.name != null ? !this.name.equals(item.name) : item.name != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(item.url) : item.url != null) {
            return false;
        }
        if (this.descriptorUrl != null ? !this.descriptorUrl.equals(item.descriptorUrl) : item.descriptorUrl != null) {
            return false;
        }
        return this.isFolder == item.isFolder;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.descriptorUrl != null ? this.descriptorUrl.hashCode() : 0);
        result = 31 * result + (this.isFolder ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Item[name='" + this.name + '\'' + ", url='" + this.url + '\'' + ", descriptorUrl='" + this.descriptorUrl + '\'' + ", properties=" + this.properties + ", folder=" + this.isFolder + ']';
    }
}

