/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.service;

import java.util.List;
import org.craftercms.core.exception.AuthenticationException;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.InvalidStoreTypeException;
import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.exception.PathNotFoundException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.exception.XmlFileParseException;
import org.craftercms.core.exception.XmlMergeException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.ItemFilter;
import org.craftercms.core.service.Tree;

public interface ContentStoreService {
    public static final int UNLIMITED_TREE_DEPTH = -1;

    public Context getContext(String var1);

    public Context createContext(String var1, String var2, String var3, String var4, String var5, boolean var6, int var7, boolean var8) throws InvalidStoreTypeException, StoreException, AuthenticationException;

    public void destroyContext(Context var1) throws InvalidContextException, StoreException, AuthenticationException;

    public boolean exists(Context var1, String var2) throws InvalidContextException, PathNotFoundException, StoreException;

    public Content findContent(Context var1, String var2) throws InvalidContextException, StoreException;

    public Content getContent(Context var1, String var2) throws InvalidContextException, PathNotFoundException, StoreException;

    public Content findContent(Context var1, CachingOptions var2, String var3) throws InvalidContextException, StoreException;

    public Content getContent(Context var1, CachingOptions var2, String var3) throws InvalidContextException, PathNotFoundException, StoreException;

    public Item findItem(Context var1, String var2) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    public Item getItem(Context var1, String var2) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    public Item findItem(Context var1, CachingOptions var2, String var3, ItemProcessor var4) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    public Item getItem(Context var1, CachingOptions var2, String var3, ItemProcessor var4) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    public List<Item> findChildren(Context var1, String var2) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    public List<Item> getChildren(Context var1, String var2) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    public List<Item> findChildren(Context var1, CachingOptions var2, String var3, ItemFilter var4, ItemProcessor var5) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    public List<Item> getChildren(Context var1, CachingOptions var2, String var3, ItemFilter var4, ItemProcessor var5) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    public Tree findTree(Context var1, String var2) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    public Tree getTree(Context var1, String var2) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    public Tree findTree(Context var1, String var2, int var3) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    public Tree getTree(Context var1, String var2, int var3) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    public Tree findTree(Context var1, CachingOptions var2, String var3, int var4, ItemFilter var5, ItemProcessor var6) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    public Tree getTree(Context var1, CachingOptions var2, String var3, int var4, ItemFilter var5, ItemProcessor var6) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;
}

