/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.processors.impl;

import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.beans.factory.annotation.Required;

public class IncludeDescriptorsProcessor
implements ItemProcessor {
    private static final Log logger = LogFactory.getLog(IncludeDescriptorsProcessor.class);
    protected static final ThreadLocal<Stack<String>> includedItemsStack = new ThreadLocal<Stack<String>>(){

        @Override
        protected Stack<String> initialValue() {
            return new Stack<String>();
        }
    };
    protected String includeElementXPathQuery;
    protected String disabledIncludeNodeXPathQuery;
    protected ContentStoreService contentStoreService;
    protected ItemProcessor includedItemsProcessor;

    @Required
    public void setIncludeElementXPathQuery(String includeElementXPathQuery) {
        this.includeElementXPathQuery = includeElementXPathQuery;
    }

    @Required
    public void setDisabledIncludeNodeXPathQuery(String disabledIncludeNodeXPathQuery) {
        this.disabledIncludeNodeXPathQuery = disabledIncludeNodeXPathQuery;
    }

    @Required
    public void setContentStoreService(ContentStoreService contentStoreService) {
        this.contentStoreService = contentStoreService;
    }

    public void setIncludedItemsProcessor(ItemProcessor includedItemsProcessor) {
        this.includedItemsProcessor = includedItemsProcessor;
    }

    @Override
    public Item process(Context context, CachingOptions cachingOptions, Item item) throws ItemProcessingException {
        if (item.getDescriptorDom() != null) {
            this.includeDescriptors(context, cachingOptions, item);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void includeDescriptors(Context context, CachingOptions cachingOptions, Item item) throws ItemProcessingException {
        String descriptorUrl = item.getDescriptorUrl();
        includedItemsStack.get().push(descriptorUrl);
        try {
            Document descriptorDom = item.getDescriptorDom();
            List includeElements = descriptorDom.selectNodes(this.includeElementXPathQuery);
            if (CollectionUtils.isEmpty((Collection)includeElements)) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Processing includes of item @ " + descriptorUrl));
            }
            for (Element includeElement : includeElements) {
                String itemToIncludePath = includeElement.getTextTrim();
                if (StringUtils.isEmpty((CharSequence)itemToIncludePath)) continue;
                if (!this.isIncludeDisabled(includeElement)) {
                    if (!includedItemsStack.get().contains(itemToIncludePath)) {
                        Item itemToInclude = this.getItemToInclude(context, cachingOptions, itemToIncludePath);
                        if (itemToInclude != null && itemToInclude.getDescriptorDom() != null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Include found in " + descriptorUrl + ": " + itemToIncludePath));
                            }
                            this.doInclude(item, includeElement, itemToInclude);
                            continue;
                        }
                        logger.warn((Object)("No descriptor item found @ " + itemToIncludePath));
                        continue;
                    }
                    logger.warn((Object)("Circular inclusion detected. Item " + itemToIncludePath + " already included"));
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Ignoring include " + itemToIncludePath + ". It's currently disabled"));
            }
        }
        finally {
            includedItemsStack.get().pop();
        }
    }

    protected boolean isIncludeDisabled(Element includeElement) {
        Node disabledIncludeNode = includeElement.selectSingleNode(this.disabledIncludeNodeXPathQuery);
        return disabledIncludeNode != null && BooleanUtils.toBoolean((String)disabledIncludeNode.getText());
    }

    protected Item getItemToInclude(Context context, CachingOptions cachingOptions, String includeSrcPath) throws ItemProcessingException {
        try {
            return this.contentStoreService.findItem(context, cachingOptions, includeSrcPath, this.includedItemsProcessor);
        }
        catch (Exception e) {
            throw new ItemProcessingException("Unable to retrieve descriptor " + includeSrcPath + " from the underlying repository", e);
        }
    }

    protected void doInclude(Item item, Element includeElement, Item itemToInclude) throws ItemProcessingException {
        List includeElementParentChildren = includeElement.getParent().content();
        int includeElementIdx = includeElementParentChildren.indexOf(includeElement);
        Element itemToIncludeRootElement = itemToInclude.getDescriptorDom().getRootElement().createCopy();
        includeElementParentChildren.remove(includeElementIdx);
        includeElementParentChildren.add(includeElementIdx, itemToIncludeRootElement);
        item.addDependencyKey(itemToInclude.getKey());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Item " + itemToInclude.getDescriptorUrl() + " included into " + item.getDescriptorUrl()));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncludeDescriptorsProcessor that = (IncludeDescriptorsProcessor)o;
        if (!this.includeElementXPathQuery.equals(that.includeElementXPathQuery)) {
            return false;
        }
        return this.contentStoreService.equals(that.contentStoreService);
    }

    public int hashCode() {
        int result = this.includeElementXPathQuery.hashCode();
        result = 31 * result + this.contentStoreService.hashCode();
        return result;
    }

    public String toString() {
        return "IncludeDescriptorsProcessor[contentStoreService=" + this.contentStoreService + ", includeElementXPathQuery='" + this.includeElementXPathQuery + '\'' + ']';
    }
}

