/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.processors.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class AttributeAddingProcessor
implements ItemProcessor {
    private static final Log logger = LogFactory.getLog(AttributeAddingProcessor.class);
    protected Map<String, Map<String, String>> attributeMappings;

    public void setAttributeMappings(Map<String, Map<String, String>> attributeMappings) {
        this.attributeMappings = attributeMappings;
    }

    @Override
    public Item process(Context context, CachingOptions cachingOptions, Item item) throws ItemProcessingException {
        Document document = item.getDescriptorDom();
        if (document != null && MapUtils.isNotEmpty(this.attributeMappings)) {
            for (Map.Entry<String, Map<String, String>> mapping : this.attributeMappings.entrySet()) {
                String xpath = mapping.getKey();
                Map<String, String> attributes = mapping.getValue();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Adding attributes " + attributes + " to elements that match " + xpath + " for descriptor of " + item));
                }
                if (!MapUtils.isNotEmpty(attributes)) continue;
                List elements = document.selectNodes(xpath);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Number of matching elements: " + elements.size()));
                }
                if (!CollectionUtils.isNotEmpty((Collection)elements)) continue;
                for (Element element : elements) {
                    for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                        this.addAttribute(attribute, element);
                    }
                }
            }
        }
        return item;
    }

    protected void addAttribute(Map.Entry<String, String> attribute, Element element) {
        String name = attribute.getKey();
        String value = attribute.getValue();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding attribute " + name + "=" + value + " to element " + element.getUniquePath()));
        }
        element.add(DocumentHelper.createAttribute((Element)element, (String)name, (String)value));
    }
}

