/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.processors.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractTaggingProcessor
implements ItemProcessor {
    private static final Log logger = LogFactory.getLog(AbstractTaggingProcessor.class);
    protected String newField;
    protected String defaultValue;

    @Required
    public void setNewField(String newField) {
        this.newField = newField;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    protected abstract String getTagValues(Item var1);

    protected void addNewField(Item item, String values) {
        Element root;
        Document document;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Tagging item with field: " + this.newField + " and value: " + values));
        }
        if ((document = item.getDescriptorDom()) != null && (root = document.getRootElement()) != null) {
            for (String value : values.split(",")) {
                Element newElement = root.addElement(this.newField);
                newElement.setText(value);
            }
        }
    }

    @Override
    public Item process(Context context, CachingOptions cachingOptions, Item item) throws ItemProcessingException {
        String values;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Processing item: " + item));
        }
        if (StringUtils.isNotEmpty((CharSequence)(values = this.getTagValues(item)))) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Item will be tagged");
            }
            this.addNewField(item, values);
        }
        return item;
    }
}

