/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.controller.rest;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.validation.ValidationException;
import org.craftercms.commons.validation.ValidationResult;
import org.craftercms.commons.validation.ValidationRuntimeException;
import org.craftercms.core.exception.AuthenticationException;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.PathNotFoundException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

public class RestControllerBase {
    private static final Log logger = LogFactory.getLog(RestControllerBase.class);
    public static final String REST_BASE_URI = "/api/1";
    public static final String MESSAGE_MODEL_ATTRIBUTE_NAME = "message";

    @ExceptionHandler(value={InvalidContextException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public Map<String, Object> handleInvalidContextException(HttpServletRequest request, InvalidContextException e) {
        return this.handleException(request, e);
    }

    @ExceptionHandler(value={AuthenticationException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public Map<String, Object> handleAuthenticationException(HttpServletRequest request, AuthenticationException e) {
        return this.handleException(request, e);
    }

    @ExceptionHandler(value={PathNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public Map<String, Object> handlePathNotFoundException(HttpServletRequest request, PathNotFoundException e) {
        return this.handleException(request, e);
    }

    @ExceptionHandler(value={ValidationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ValidationResult handleValidationException(HttpServletRequest request, ValidationException e) {
        logger.error((Object)("Request for " + request.getRequestURI() + " failed"), (Throwable)e);
        return e.getResult();
    }

    @ExceptionHandler(value={ValidationRuntimeException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ValidationResult handleValidationRuntimeException(HttpServletRequest request, ValidationRuntimeException e) {
        logger.error((Object)("Request for " + request.getRequestURI() + " failed"), (Throwable)e);
        return e.getResult();
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public Map<String, Object> handleException(HttpServletRequest request, Exception e) {
        logger.error((Object)("Request for " + request.getRequestURI() + " failed"), (Throwable)e);
        return this.createMessageModel(MESSAGE_MODEL_ATTRIBUTE_NAME, e.getMessage());
    }

    protected Map<String, Object> createMessageModel(String attributeName, Object attributeValue) {
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        model.put(attributeName, attributeValue);
        return model;
    }
}

