/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.cache.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.cache.Cache;
import org.craftercms.core.cache.CacheItem;
import org.craftercms.core.cache.impl.TopologicalCacheItemSorter;

public class TopologicalCacheItemSorterImpl
implements TopologicalCacheItemSorter {
    private static final Log logger = LogFactory.getLog(TopologicalCacheItemSorterImpl.class);

    @Override
    public List<CacheItem> sortTopologically(List<CacheItem> items, Cache cache) {
        ArrayList<CacheItem> sortedItems = new ArrayList<CacheItem>();
        List<CacheItem> itemsWithNoDependants = this.getItemsWithNoDependants(items, cache);
        HashSet<CacheItem> visitedItems = new HashSet<CacheItem>();
        for (CacheItem item : itemsWithNoDependants) {
            this.visitItem(item, visitedItems, sortedItems, cache);
        }
        Iterator i = sortedItems.iterator();
        while (i.hasNext()) {
            CacheItem item;
            item = (CacheItem)i.next();
            if (items.contains(item)) continue;
            i.remove();
        }
        return sortedItems;
    }

    private void visitItem(CacheItem item, Set<CacheItem> visitedItems, List<CacheItem> sortedItems, Cache cache) {
        if (!visitedItems.contains(item)) {
            visitedItems.add(item);
            List<Object> dependencyKeys = item.getDependencyKeys();
            if (CollectionUtils.isNotEmpty(dependencyKeys)) {
                for (Object dependencyKey : dependencyKeys) {
                    CacheItem dependency = this.getCacheItem(cache, item.getScope(), dependencyKey);
                    if (dependency == null) continue;
                    this.visitItem(dependency, visitedItems, sortedItems, cache);
                }
            }
            sortedItems.add(item);
        }
    }

    private List<CacheItem> getItemsWithNoDependants(List<CacheItem> items, Cache cache) {
        ArrayList<CacheItem> itemsWithNoDependants = new ArrayList<CacheItem>(items);
        Iterator<CacheItem> i = items.iterator();
        while (i.hasNext()) {
            boolean isDependency = false;
            CacheItem possibleDependency = i.next();
            Iterator<CacheItem> j = items.iterator();
            while (j.hasNext() && !isDependency) {
                CacheItem item = j.next();
                if (item.equals(possibleDependency) || !this.isDependency(item, possibleDependency, cache)) continue;
                itemsWithNoDependants.remove(possibleDependency);
                isDependency = true;
            }
        }
        return itemsWithNoDependants;
    }

    private boolean isDependency(CacheItem item, CacheItem possibleDependency, Cache cache) {
        List<Object> dependencyKeys = item.getDependencyKeys();
        if (CollectionUtils.isNotEmpty(dependencyKeys)) {
            for (Object dependencyKey : dependencyKeys) {
                if (dependencyKey.equals(possibleDependency.getKey())) {
                    return true;
                }
                CacheItem dependency = this.getCacheItem(cache, item.getScope(), dependencyKey);
                if (dependency == null || !this.isDependency(dependency, possibleDependency, cache)) continue;
                return true;
            }
        }
        return false;
    }

    private CacheItem getCacheItem(Cache cache, String scope, Object key) {
        try {
            return cache.get(scope, key);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to retrieve object with key " + key + " at cache scope " + scope), (Throwable)e);
            return null;
        }
    }
}

