/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.cache.impl;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.cache.Cache;
import org.craftercms.core.cache.CacheItem;
import org.craftercms.core.cache.CacheLoader;
import org.craftercms.core.cache.impl.CacheRefresher;
import org.craftercms.core.cache.impl.TopologicalCacheItemSorter;
import org.craftercms.core.cache.impl.TopologicalCacheItemSorterImpl;
import org.craftercms.core.exception.InternalCacheEngineException;

public class CacheRefresherImpl
implements CacheRefresher {
    private static final Log logger = LogFactory.getLog(CacheRefresherImpl.class);
    protected TopologicalCacheItemSorter sorter = new TopologicalCacheItemSorterImpl();

    public void setSorter(TopologicalCacheItemSorter sorter) {
        this.sorter = sorter;
    }

    @Override
    public void refreshItems(List<CacheItem> itemsToRefresh, Cache cache) {
        itemsToRefresh = this.sorter.sortTopologically(itemsToRefresh, cache);
        for (CacheItem item : itemsToRefresh) {
            try {
                this.refreshItem(item, cache);
            }
            catch (Exception ex) {
                logger.error((Object)("Refresh for " + this.getScopeAndKeyString(item) + " failed"), (Throwable)ex);
            }
        }
    }

    protected void refreshItem(CacheItem item, Cache cache) throws Exception {
        Object newValue;
        CacheLoader loader = item.getLoader();
        Object[] loaderParams = item.getLoaderParams();
        if (loader == null) {
            throw new InternalCacheEngineException("No cache loader for " + this.getScopeAndKeyString(item));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Refreshing " + this.getScopeAndKeyString(item)));
        }
        if ((newValue = loader.load(loaderParams)) != null) {
            cache.put(item.getScope(), item.getKey(), newValue, item.getDependencyKeys(), item.getTicksToExpire(), item.getTicksToRefresh(), item.getLoader(), item.getLoaderParams());
        } else {
            cache.remove(item.getScope(), item.getKey());
        }
    }

    protected String getScopeAndKeyString(CacheItem item) {
        return "[scope='" + item.getScope() + "', key=" + item.getKey() + "]";
    }
}

