/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.mongo;

import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.craftercms.commons.mongo.MongoDataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class MongoScriptRunner {
    private static final Logger logger = LoggerFactory.getLogger(MongoScriptRunner.class);
    private Mongo mongo;
    private String dbName;
    private String username;
    private String password;
    private List<Resource> scriptPaths;
    private boolean runOnInit = true;
    private boolean useMongoClient;
    private String mongoClientBin;
    private String connectionStr;

    @Required
    public void setMongo(Mongo mongo) {
        this.mongo = mongo;
    }

    @Required
    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Required
    public void setScriptPaths(List<Resource> scriptPaths) {
        this.scriptPaths = scriptPaths;
    }

    public void setRunOnInit(boolean runOnInit) {
        this.runOnInit = runOnInit;
    }

    public void setUseMongoClient(boolean useMongoClient) {
        this.useMongoClient = useMongoClient;
    }

    public void setMongoClientBin(String mongoClientBin) {
        this.mongoClientBin = mongoClientBin;
    }

    public void setConnectionStr(String connectionStr) {
        this.connectionStr = connectionStr;
    }

    @PostConstruct
    public void init() {
        logger.debug("Running Scripts?", (Object)this.runOnInit);
        if (this.runOnInit) {
            logger.debug("Using Mongo Client", (Object)this.useMongoClient);
            if (this.useMongoClient) {
                this.runScriptsWithMongoClient();
            } else {
                this.runScripts();
            }
        }
    }

    private void runScriptsWithMongoClient() {
        ArrayList<String> toExecute = new ArrayList<String>();
        try {
            for (Resource scriptPath : this.scriptPaths) {
                if (scriptPath.getFile().isDirectory()) {
                    Files.walkFileTree(scriptPath.getFile().toPath(), new JSFileVisitor(toExecute));
                    continue;
                }
                toExecute.add(scriptPath.getFile().getAbsolutePath());
            }
            Path allScripsFile = Files.createTempFile("ScriptRunner", ".js", new FileAttribute[0]);
            StringBuilder builder = new StringBuilder();
            for (String path : toExecute) {
                builder.append(String.format("load('%s');\n", path));
            }
            FileUtils.writeStringToFile((File)allScripsFile.toFile(), (String)builder.toString(), (String)"UTF-8");
            this.runScript(allScripsFile);
            Files.deleteIfExists(allScripsFile);
        }
        catch (IOException | MongoDataException ex) {
            logger.error("Unable to run script using MongoClient", (Throwable)ex);
        }
    }

    public void runScripts() {
        try {
            DB db = this.getDB();
            logger.debug("Running Scriptns in {}", (Object)db.getName());
            for (Resource scriptPath : this.scriptPaths) {
                this.runScript(db, scriptPath);
            }
        }
        catch (Exception ex) {
            logger.error("Unable to run scripts due a internal exception ", (Throwable)ex);
        }
    }

    private void runScript(DB db, Resource scriptPath) throws MongoDataException {
        block7: {
            try {
                String script;
                if (scriptPath.getFile().isDirectory()) {
                    File[] files = scriptPath.getFile().listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.toLowerCase().endsWith(".js");
                        }
                    });
                    List<File> orderFiles = Arrays.asList(files);
                    Collections.sort(orderFiles, new Comparator<File>(){

                        @Override
                        public int compare(File o1, File o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    });
                    logger.debug("Directory {} files to exec {}", (Object)scriptPath.getFile(), orderFiles);
                    for (File file : orderFiles) {
                        this.runScript(db, (Resource)new FileSystemResource(file.getPath()));
                    }
                    break block7;
                }
                logger.debug("Running Script {}", (Object)scriptPath.getURI());
                try {
                    script = IOUtils.toString((InputStream)scriptPath.getInputStream(), (String)"UTF-8");
                }
                catch (IOException e) {
                    throw new MongoDataException("Unable to read script at " + scriptPath.getURI().toString());
                }
                CommandResult result = db.doEval(script, new Object[0]);
                if (!result.ok()) {
                    MongoException ex = result.getException();
                    throw new MongoDataException("An error occurred while running script at " + scriptPath.getURI().toString(), ex);
                }
                logger.info("Mongo script at {} executed successfully", (Object)scriptPath.getDescription());
            }
            catch (IOException ex) {
                logger.error("Unable to read files from {}", (Throwable)ex);
            }
        }
    }

    private void runScript(Path scriptPath) throws MongoDataException {
        try {
            String errOut;
            String stdOut;
            ProcessBuilder mongoProcess = new ProcessBuilder(this.getCommands(scriptPath));
            Process process = mongoProcess.start();
            int result = process.waitFor();
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                IOUtils.copy((InputStream)process.getInputStream(), (OutputStream)out);
                stdOut = new String(out.toByteArray(), "UTF-8");
                out.reset();
                IOUtils.copy((InputStream)process.getErrorStream(), (OutputStream)out);
                errOut = new String(out.toByteArray(), "UTF-8");
                IOUtils.copy((InputStream)process.getInputStream(), (OutputStream)out);
            }
            if (result != 0) {
                throw new IOException("Process return error \n std out:" + stdOut + "\n err out: \n" + errOut);
            }
            logger.debug("Process return \n std out:" + stdOut + "\n err out: \n" + errOut);
        }
        catch (IOException | InterruptedException ex) {
            logger.error("Unable to Execute mongo Process", (Throwable)ex);
        }
    }

    private List<String> getCommands(Path scriptPath) throws MongoDataException {
        ArrayList<String> commandList = new ArrayList<String>();
        if (SystemUtils.IS_OS_WINDOWS) {
            commandList.add("CMD");
            commandList.add("/C");
        }
        if (StringUtils.isBlank((CharSequence)this.mongoClientBin)) {
            throw new MongoDataException("Unable to run scripts, mongo client bin path is not set ");
        }
        String pwd = null;
        String authSource = null;
        String user = null;
        MongoClientURI uri = new MongoClientURI(this.connectionStr);
        if (uri.getCredentials() != null) {
            authSource = uri.getCredentials().getSource();
            user = uri.getCredentials().getUserName();
            if (uri.getCredentials().getPassword() != null) {
                pwd = new String(uri.getCredentials().getPassword());
            }
        }
        String replicaSetName = "";
        if (uri.getHosts().size() > 1) {
            replicaSetName = uri.getOptions().getRequiredReplicaSetName() + "/";
        }
        String host = StringUtils.trim((String)(replicaSetName + StringUtils.join((Iterable)uri.getHosts(), (String)",")));
        commandList.add(this.mongoClientBin);
        commandList.add("--host");
        commandList.add(host);
        commandList.add(uri.getDatabase());
        if (StringUtils.isNotBlank((CharSequence)user) && StringUtils.isNotBlank((CharSequence)pwd) && StringUtils.isNotBlank((CharSequence)authSource)) {
            commandList.add("-u");
            commandList.add(user);
            commandList.add("-p");
            commandList.add(pwd);
            commandList.add("--authenticationDatabase");
            commandList.add(authSource);
        }
        commandList.add(scriptPath.toAbsolutePath().toString());
        return commandList;
    }

    private DB getDB() throws MongoDataException {
        DB db = this.mongo.getDB(this.dbName);
        logger.debug("Getting DB {}", (Object)this.dbName);
        if (!StringUtils.isBlank((CharSequence)this.password) && !db.authenticate(this.username, this.password.toCharArray())) {
            throw new MongoDataException("Unable to authenticate with given user/pwd");
        }
        return db;
    }

    class JSFileVisitor
    extends SimpleFileVisitor<Path> {
        private List<String> filesTOAdd;

        public JSFileVisitor(List<String> filesTOAdd) {
            this.filesTOAdd = filesTOAdd;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (attrs.isRegularFile() && attrs.size() > 0L && StringUtils.endsWithIgnoreCase((CharSequence)file.toString(), (CharSequence)".js")) {
                this.filesTOAdd.add(file.toAbsolutePath().toString());
            }
            return super.visitFile(file, attrs);
        }
    }
}

