/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.mongo;

import com.mongodb.MongoClientOptions;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class MongoClientOptionsFactory
extends AbstractFactoryBean<MongoClientOptions> {
    private static final int PRIMARY_READ_PREFERENCE = 1;
    private static final int NEAREST_READ_PREFERENCE = 2;
    private static final int SECONDARY_READ_PREFERENCE = 3;
    private int readPreference;
    private boolean alwaysUseMBeans;
    private boolean autoConnectRetry;
    private int connectionsPerHost;
    private boolean cursorFinalizerEnabled;
    private int connectTimeout;
    private long maxAutoConnectRetryTime;
    private int maxWaitTime;
    private boolean socketKeepAlive;
    private String writeConcern;
    private int threadsAllowedToBlockForConnectionMultiplier;

    public void setReadPreference(int readPreference) {
        this.readPreference = readPreference;
    }

    public void setAlwaysUseMBeans(boolean alwaysUseMBeans) {
        this.alwaysUseMBeans = alwaysUseMBeans;
    }

    public void setAutoConnectRetry(boolean autoConnectRetry) {
        this.autoConnectRetry = autoConnectRetry;
    }

    public void setConnectionsPerHost(int connectionsPerHost) {
        this.connectionsPerHost = connectionsPerHost;
    }

    public void setCursorFinalizerEnabled(boolean cursorFinalizerEnabled) {
        this.cursorFinalizerEnabled = cursorFinalizerEnabled;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setMaxAutoConnectRetryTime(long maxAutoConnectRetryTime) {
        this.maxAutoConnectRetryTime = maxAutoConnectRetryTime;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public void setSocketKeepAlive(boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
    }

    public void setWriteConcern(String writeConcern) {
        this.writeConcern = writeConcern;
    }

    public void setThreadsAllowedToBlockForConnectionMultiplier(int threadsAllowedToBlockForConnectionMultiplier) {
        this.threadsAllowedToBlockForConnectionMultiplier = threadsAllowedToBlockForConnectionMultiplier;
    }

    public Class<?> getObjectType() {
        return MongoClientOptions.class;
    }

    protected MongoClientOptions createInstance() throws Exception {
        MongoClientOptions.Builder builder = MongoClientOptions.builder();
        builder.alwaysUseMBeans(this.alwaysUseMBeans);
        builder.autoConnectRetry(this.autoConnectRetry);
        builder.connectionsPerHost(this.connectionsPerHost);
        builder.cursorFinalizerEnabled(this.cursorFinalizerEnabled);
        builder.connectTimeout(this.connectTimeout);
        builder.maxAutoConnectRetryTime(this.maxAutoConnectRetryTime);
        builder.maxWaitTime(this.maxWaitTime);
        switch (this.readPreference) {
            case 1: {
                builder.readPreference(ReadPreference.primary());
                break;
            }
            case 2: {
                builder.readPreference(ReadPreference.nearest());
                break;
            }
            case 3: {
                builder.readPreference(ReadPreference.secondary());
                break;
            }
            default: {
                builder.readPreference(ReadPreference.primary());
            }
        }
        builder.socketKeepAlive(this.socketKeepAlive);
        builder.writeConcern(WriteConcern.valueOf((String)this.writeConcern));
        builder.threadsAllowedToBlockForConnectionMultiplier(this.threadsAllowedToBlockForConnectionMultiplier);
        return builder.build();
    }
}

