/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class MongoClientFactory
extends AbstractFactoryBean<MongoClient> {
    public static final String DEFAULT_MONGO_HOST = "127.0.0.1";
    public static final int DEFAULT_MONGO_PORT = 27017;
    private Logger logger = LoggerFactory.getLogger(MongoClientFactory.class);
    private MongoClientOptions options;
    private String connectionString;
    private String username;
    private String password;

    public Class<?> getObjectType() {
        return MongoClient.class;
    }

    protected MongoClient createInstance() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.connectionString)) {
            this.logger.info("No connection string specified, connecting to {}:{}", new Object[]{this.connectionString, DEFAULT_MONGO_HOST, 27017});
            return new MongoClient(new ServerAddress(DEFAULT_MONGO_HOST, 27017));
        }
        StringTokenizer st = new StringTokenizer(this.connectionString, ",");
        ArrayList<ServerAddress> addressList = new ArrayList<ServerAddress>();
        while (st.hasMoreElements()) {
            String server = st.nextElement().toString();
            this.logger.debug("Processing first server found with string {}", (Object)server);
            String[] serverAndPort = server.split(":");
            if (serverAndPort.length == 2) {
                this.logger.debug("Server string defines host {} and port {}", (Object)serverAndPort[0], (Object)serverAndPort[1]);
                if (StringUtils.isBlank((CharSequence)serverAndPort[0])) {
                    throw new IllegalArgumentException("Given host can't be empty");
                }
                int portNumber = NumberUtils.toInt((String)serverAndPort[1]);
                if (portNumber == 0) {
                    throw new IllegalArgumentException("Given port number " + portNumber + " is not valid");
                }
                addressList.add(new ServerAddress(serverAndPort[0], portNumber));
                continue;
            }
            if (serverAndPort.length == 1) {
                this.logger.debug("Server string defines host {} only. Using default port ", (Object)serverAndPort[0]);
                if (StringUtils.isBlank((CharSequence)serverAndPort[0])) {
                    throw new IllegalArgumentException("Given host can't be empty");
                }
                addressList.add(new ServerAddress(serverAndPort[0], 27017));
                continue;
            }
            throw new IllegalArgumentException("Given connection string is not valid");
        }
        this.logger.debug("Creating MongoClient with addresses: {}", addressList);
        if (this.options != null) {
            return new MongoClient(addressList, this.options);
        }
        return new MongoClient(addressList);
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public void setOptions(MongoClientOptions options) {
        this.options = options;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

