/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.mongo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSFile;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bson.types.ObjectId;
import org.craftercms.commons.file.FileUtils;

public class FileInfo {
    private String md5;
    private ObjectId fileId;
    private String contentType;
    private String fileSize;
    private String storeName;
    private String fileName;
    private Date savedDate;
    private long fileSizeBytes;
    private Map<String, Object> attributes;
    @JsonIgnore
    private InputStream inputStream;

    FileInfo(GridFSFile savedFile, boolean withInputStream) {
        this.md5 = savedFile.getMD5();
        this.fileId = (ObjectId)savedFile.getId();
        this.contentType = savedFile.getContentType();
        this.fileSize = FileUtils.readableFileSize((long)savedFile.getLength());
        this.storeName = savedFile.getFilename();
        this.savedDate = savedFile.getUploadDate();
        this.fileSizeBytes = savedFile.getLength();
        if (withInputStream && savedFile instanceof GridFSDBFile) {
            this.inputStream = ((GridFSDBFile)savedFile).getInputStream();
        }
        this.attributes = new HashMap<String, Object>();
    }

    public FileInfo() {
        this.attributes = new HashMap<String, Object>();
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public ObjectId getFileId() {
        return this.fileId;
    }

    public void setFileId(ObjectId fileId) {
        this.fileId = fileId;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(String fileSize) {
        this.fileSize = fileSize;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public Date getSavedDate() {
        return this.savedDate;
    }

    public void setSavedDate(Date savedDate) {
        this.savedDate = savedDate;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public long getFileSizeBytes() {
        return this.fileSizeBytes;
    }

    public void setFileSizeBytes(long fileSizeBytes) {
        this.fileSizeBytes = fileSizeBytes;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileInfo fileInfo = (FileInfo)o;
        if (!this.fileId.equals((Object)fileInfo.fileId)) {
            return false;
        }
        return this.storeName.equals(fileInfo.storeName);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public int hashCode() {
        int result = this.fileId.hashCode();
        result = 31 * result + this.storeName.hashCode();
        return result;
    }

    public String toString() {
        return "FileInfo{md5='" + this.md5 + '\'' + ", fileId=" + this.fileId + ", contentType='" + this.contentType + '\'' + ", fileSize='" + this.fileSize + '\'' + ", storeName='" + this.storeName + '\'' + ", savedDate=" + this.savedDate + '}';
    }
}

