/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.mongo;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.FileExistsException;
import org.bson.types.ObjectId;
import org.craftercms.commons.mongo.FileInfo;
import org.craftercms.commons.mongo.MongoDataException;

public interface CrudRepository<T> {
    public void insert(T var1) throws MongoDataException;

    public void insert(T ... var1) throws MongoDataException;

    public void save(T var1) throws MongoDataException;

    public void save(String var1, Object ... var2) throws MongoDataException;

    public void update(String var1, T var2, boolean var3, boolean var4) throws MongoDataException;

    public void update(String var1, T var2) throws MongoDataException;

    public void update(String var1, String var2, boolean var3, boolean var4) throws MongoDataException;

    public void update(String var1, String var2, boolean var3, boolean var4, Object ... var5) throws MongoDataException;

    public long count() throws MongoDataException;

    public long count(String var1) throws MongoDataException;

    public long count(String var1, Object ... var2) throws MongoDataException;

    public Iterable<T> findAll() throws MongoDataException;

    public Iterable<T> find(String var1) throws MongoDataException;

    public Iterable<T> find(String var1, Object ... var2) throws MongoDataException;

    public T findOne(String var1) throws MongoDataException;

    public T findOne(String var1, Object ... var2) throws MongoDataException;

    public void remove(String var1, Object ... var2) throws MongoDataException;

    public T findById(String var1) throws MongoDataException;

    public void remove(String var1) throws MongoDataException;

    public void removeById(String var1) throws MongoDataException;

    public FileInfo saveFile(InputStream var1, String var2, String var3, ObjectId var4) throws MongoDataException, FileExistsException;

    public FileInfo saveFile(InputStream var1, String var2, String var3) throws MongoDataException, FileExistsException;

    public FileInfo getFileInfo(ObjectId var1) throws FileNotFoundException;

    public FileInfo getFileInfo(String var1) throws FileNotFoundException;

    public FileInfo readFile(ObjectId var1) throws FileNotFoundException;

    public FileInfo readFile(String var1) throws FileNotFoundException;

    public void deleteFile(ObjectId var1) throws FileNotFoundException;

    public void deleteFile(String var1) throws FileNotFoundException;

    public FileInfo updateFile(ObjectId var1, InputStream var2, String var3, String var4) throws FileNotFoundException, MongoDataException, FileExistsException;

    public FileInfo updateFile(ObjectId var1, InputStream var2, String var3, String var4, boolean var5) throws FileNotFoundException, MongoDataException, FileExistsException;

    public FileInfo updateFile(InputStream var1, String var2, String var3) throws FileNotFoundException, MongoDataException, FileExistsException;

    public T findByStringId(String var1) throws MongoDataException;

    public List<FileInfo> listFilesByName(String var1);

    public void removeByStringId(String var1) throws MongoDataException;
}

