/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteResult;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.keyvalue.DefaultKeyValue;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.craftercms.commons.mongo.CrudRepository;
import org.craftercms.commons.mongo.Document;
import org.craftercms.commons.mongo.DuplicateKeyException;
import org.craftercms.commons.mongo.FileInfo;
import org.craftercms.commons.mongo.JongoQueries;
import org.craftercms.commons.mongo.MongoDataException;
import org.jongo.Find;
import org.jongo.FindOne;
import org.jongo.Jongo;
import org.jongo.MongoCollection;
import org.jongo.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractJongoRepository<T>
implements CrudRepository<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractJongoRepository.class);
    protected Class<? extends T> clazz;
    protected Jongo jongo;
    protected String collectionName;
    protected JongoQueries queries;
    protected GridFS gridfs;

    public void init() throws Exception {
        this.clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        if (this.clazz == null) {
            log.error("Unable to get class information for JongoRepository");
            throw new MongoDataException("Unable to get class information for JongoRepository");
        }
        Document documentAnnotation = this.clazz.getAnnotation(Document.class);
        this.collectionName = documentAnnotation == null ? this.clazz.getSimpleName().toLowerCase() : documentAnnotation.collectionName();
    }

    @Override
    public void insert(T document) throws MongoDataException {
        try {
            WriteResult result = this.getCollection().insert(document);
            this.checkCommandResult(result);
        }
        catch (MongoException.DuplicateKey ex) {
            String msg = "Duplicate key for document " + document;
            log.error(msg, (Throwable)ex);
            throw new DuplicateKeyException(msg, ex);
        }
        catch (MongoException ex) {
            String msg = "Unable to insert document " + document;
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
    }

    protected MongoCollection getCollection() {
        return this.jongo.getCollection(this.collectionName);
    }

    protected void checkCommandResult(WriteResult result) throws MongoDataException {
        CommandResult lastError = result.getLastError();
        log.debug("Saving send to mongodb checking result");
        log.debug("Result is {}", (Object)(lastError.ok() ? "OK" : lastError.getErrorMessage()));
        if (!lastError.ok()) {
            MongoException ex = lastError.getException();
            log.error("Unable to save into mongodb due to " + lastError.getErrorMessage(), (Throwable)ex);
            if (ex instanceof MongoException.DuplicateKey) {
                throw new DuplicateKeyException(ex.getMessage(), ex);
            }
            throw new MongoDataException(ex.getMessage(), ex);
        }
    }

    @Override
    public void insert(T ... documents) throws MongoDataException {
        try {
            WriteResult result = this.getCollection().insert((Object[])documents);
            this.checkCommandResult(result);
        }
        catch (MongoException.DuplicateKey ex) {
            String msg = "Duplicate key for documents " + Arrays.toString(documents);
            log.error(msg, (Throwable)ex);
            throw new DuplicateKeyException(msg, ex);
        }
        catch (MongoException ex) {
            String msg = "Unable to insert documents " + Arrays.toString(documents);
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
    }

    @Override
    public void save(T document) throws MongoDataException {
        try {
            WriteResult result = this.getCollection().save(document);
            this.checkCommandResult(result);
        }
        catch (MongoException.DuplicateKey ex) {
            String msg = "Duplicate key for document " + document;
            log.error(msg, (Throwable)ex);
            throw new DuplicateKeyException(msg, ex);
        }
        catch (MongoException ex) {
            String msg = "Unable to save document " + document;
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
    }

    @Override
    public void save(String query, Object ... queryParams) throws MongoDataException {
        try {
            WriteResult writeResult = this.getCollection().insert(query, queryParams);
            this.checkCommandResult(writeResult);
        }
        catch (MongoException.DuplicateKey ex) {
            String msg = "Duplicate key for save query " + query + " of type " + this.clazz.getName() + " with params " + Arrays.toString(queryParams);
            log.error(msg, (Throwable)ex);
            throw new DuplicateKeyException(msg, ex);
        }
        catch (MongoException ex) {
            String msg = "Unable to save document by query " + query + " of type " + this.clazz.getName() + " with params " + Arrays.toString(queryParams);
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
    }

    @Override
    public void update(String id, T updateObject, boolean multi, boolean upsert) throws MongoDataException {
        try {
            Update update = this.getCollection().update(new ObjectId(id));
            if (multi) {
                update.multi();
            }
            if (upsert) {
                update.upsert();
            }
            WriteResult result = update.with(updateObject);
            this.checkCommandResult(result);
        }
        catch (MongoException.DuplicateKey ex) {
            String msg = "Duplicate key for update with id='" + id + "', updatedObject=" + updateObject + ", multi=" + multi + ", upsert=" + upsert;
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
        catch (MongoException ex) {
            String msg = "Unable to do update with id='" + id + "', updatedObject=" + updateObject + ", multi=" + multi + ", upsert=" + upsert;
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
    }

    @Override
    public void update(String id, T updateObject) throws MongoDataException {
        this.update(id, updateObject, false, false);
    }

    @Override
    public void update(String id, String modifier, boolean multi, boolean upsert) throws MongoDataException {
        try {
            Update update = this.getCollection().update(new ObjectId(id));
            if (multi) {
                update.multi();
            }
            if (upsert) {
                update.upsert();
            }
            WriteResult result = update.with(modifier);
            this.checkCommandResult(result);
        }
        catch (MongoException.DuplicateKey ex) {
            String msg = "Duplicate key for update with id='" + id + "', modifier=" + modifier + ", multi=" + multi + ", upsert=" + upsert;
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
        catch (MongoException ex) {
            String msg = "Unable to do update with id='" + id + "', modifier=" + modifier + ", multi=" + multi + ", upsert=" + upsert;
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
    }

    @Override
    public void update(String id, String modifier, boolean multi, boolean upsert, Object ... params) throws MongoDataException {
        try {
            Update update = this.getCollection().update(new ObjectId(id));
            if (multi) {
                update.multi();
            }
            if (upsert) {
                update.upsert();
            }
            WriteResult result = update.with(modifier, params);
            this.checkCommandResult(result);
        }
        catch (MongoException.DuplicateKey ex) {
            String msg = "Duplicate key for update with id='" + id + "', modifier=" + modifier + ", multi=" + multi + ", upsert=" + upsert + ", params" + Arrays.toString(params);
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
        catch (MongoException ex) {
            String msg = "Unable to do update with id='" + id + "', modifier=" + modifier + ", multi=" + multi + ", upsert=" + upsert + ", params" + Arrays.toString(params);
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
    }

    @Override
    public long count() throws MongoDataException {
        try {
            return this.getCollection().count();
        }
        catch (MongoException ex) {
            String msg = "Unable to count all documents of type " + this.clazz.getName();
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
    }

    @Override
    public long count(String query) throws MongoDataException {
        try {
            return this.getCollection().count(query);
        }
        catch (MongoException ex) {
            String msg = "Unable to count documents of type " + this.clazz.getName() + " that match the query " + query;
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
    }

    @Override
    public long count(String query, Object ... queryParams) throws MongoDataException {
        try {
            return this.getCollection().count(query, queryParams);
        }
        catch (MongoException ex) {
            String msg = "Unable to count documents of type " + this.clazz.getName() + " that match the query " + query + " with params " + Arrays.toString(queryParams);
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
    }

    @Override
    public Iterable<T> findAll() throws MongoDataException {
        try {
            return this.returnList(this.getCollection().find());
        }
        catch (MongoException ex) {
            String msg = "Unable to find all documents of type " + this.clazz.getName();
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
    }

    @Override
    public Iterable<T> find(String query) throws MongoDataException {
        try {
            return this.returnList(this.getCollection().find(query));
        }
        catch (MongoException ex) {
            String msg = "Unable to find documents by query " + query + " of type " + this.clazz.getName();
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
    }

    @Override
    public Iterable<T> find(String query, Object ... queryParams) throws MongoDataException {
        try {
            return this.returnList(this.getCollection().find(query, queryParams));
        }
        catch (MongoException ex) {
            String msg = "Unable to find documents by query " + query + " of type " + this.clazz.getName() + " with params " + Arrays.toString(queryParams);
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
    }

    @Override
    public T findOne(String query) throws MongoDataException {
        try {
            return this.returnSimple(this.getCollection().findOne(query));
        }
        catch (MongoException ex) {
            String msg = "Unable to find document by query " + query + " of type " + this.clazz.getName();
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
    }

    @Override
    public T findOne(String query, Object ... queryParams) throws MongoDataException {
        try {
            return (T)this.getCollection().findOne(query, queryParams).as(this.clazz);
        }
        catch (MongoException ex) {
            String msg = "Unable to find document by query " + query + " of type " + this.clazz.getName() + " with params " + Arrays.toString(queryParams);
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
    }

    @Override
    public void remove(String query, Object ... queryParams) throws MongoDataException {
        try {
            WriteResult writeResult = this.getCollection().remove(query, queryParams);
            this.checkCommandResult(writeResult);
        }
        catch (MongoException ex) {
            String msg = "Unable to remove document by query " + query + " of type " + this.clazz.getName() + " with params " + Arrays.toString(queryParams);
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
    }

    @Override
    public T findById(String id) throws MongoDataException {
        if (!ObjectId.isValid((String)id)) {
            throw new IllegalArgumentException("Given String " + id + " is not a valid Object Id");
        }
        try {
            return (T)this.getCollection().findOne(new ObjectId(id)).as(this.clazz);
        }
        catch (MongoException ex) {
            String msg = "Unable to find document of type " + this.clazz.getName() + " by id '" + id + "'";
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
        catch (IllegalArgumentException ex) {
            String msg = "Given id '" + id + "' can't be converted to an ObjectId";
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
    }

    @Override
    public void remove(String query) throws MongoDataException {
        try {
            WriteResult writeResult = this.getCollection().remove(query);
            this.checkCommandResult(writeResult);
        }
        catch (MongoException ex) {
            String msg = "Unable to remove document by query " + query + " of type " + this.clazz.getName();
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
    }

    @Override
    public void removeById(String id) throws MongoDataException {
        try {
            WriteResult writeResult = this.getCollection().remove(new ObjectId(id));
            this.checkCommandResult(writeResult);
        }
        catch (MongoException ex) {
            String msg = "Unable to remove document of type " + this.clazz.getName() + " by id '" + id + "'";
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
        catch (IllegalArgumentException ex) {
            String msg = "Given id '" + id + "' can't be converted to an ObjectId";
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
    }

    @Override
    public FileInfo saveFile(InputStream inputStream, String storeName, String contentType, ObjectId fileId) throws MongoDataException, FileExistsException {
        try {
            if (this.gridfs.findOne(storeName) != null) {
                log.error("A file named {} already exists", (Object)storeName);
                throw new FileExistsException("File with name " + storeName + " already Exists");
            }
            GridFSInputFile savedFile = this.gridfs.createFile(inputStream, storeName, true);
            savedFile.setContentType(contentType);
            if (fileId != null) {
                log.debug("Saving file with given Id {} probably a update", (Object)fileId);
                savedFile.setId((Object)fileId);
            }
            savedFile.save();
            FileInfo fileInfo = new FileInfo((GridFSFile)savedFile, false);
            log.debug("File {} was saved " + fileInfo);
            return fileInfo;
        }
        catch (MongoException ex) {
            log.error("Unable to save file");
            throw new MongoDataException("Unable to save file to GridFs", ex);
        }
    }

    @Override
    public FileInfo saveFile(InputStream inputStream, String storeName, String contentType) throws MongoDataException, FileExistsException {
        return this.saveFile(inputStream, storeName, contentType, null);
    }

    @Override
    public FileInfo getFileInfo(ObjectId fileId) throws FileNotFoundException {
        return new FileInfo((GridFSFile)this.validateObject(fileId), false);
    }

    @Override
    public FileInfo getFileInfo(String storeName) throws FileNotFoundException {
        return new FileInfo((GridFSFile)this.validateObject(storeName), false);
    }

    @Override
    public FileInfo readFile(ObjectId fileId) throws FileNotFoundException {
        return new FileInfo((GridFSFile)this.validateObject(fileId), true);
    }

    @Override
    public FileInfo readFile(String storeName) throws FileNotFoundException {
        return new FileInfo((GridFSFile)this.validateObject(storeName), true);
    }

    @Override
    public void deleteFile(ObjectId fileId) throws FileNotFoundException {
        this.gridfs.remove((DBObject)this.validateObject(fileId));
    }

    @Override
    public void deleteFile(String storeName) throws FileNotFoundException {
        this.gridfs.remove((DBObject)this.validateObject(storeName));
    }

    @Override
    public FileInfo updateFile(ObjectId fileId, InputStream inputStream, String storeName, String contentType) throws FileNotFoundException, MongoDataException, FileExistsException {
        return this.updateFile(fileId, inputStream, storeName, contentType, false);
    }

    @Override
    public FileInfo updateFile(ObjectId fileId, InputStream inputStream, String storeName, String contentType, boolean sameFileId) throws FileNotFoundException, MongoDataException, FileExistsException {
        this.gridfs.remove((DBObject)this.validateObject(fileId));
        return this.saveFile(inputStream, storeName, contentType, (ObjectId)(sameFileId ? fileId : null));
    }

    @Override
    public FileInfo updateFile(InputStream inputStream, String storeName, String contentType) throws FileNotFoundException, MongoDataException, FileExistsException {
        this.gridfs.remove((DBObject)this.validateObject(storeName));
        return this.saveFile(inputStream, storeName, contentType);
    }

    @Override
    public T findByStringId(String id) throws MongoDataException {
        try {
            return (T)this.getCollection().findOne("{_id:#}", new Object[]{id}).as(this.clazz);
        }
        catch (MongoException ex) {
            String msg = "Unable to find document of type " + this.clazz.getName() + " by id '" + id + "'";
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
    }

    @Override
    public List<FileInfo> listFilesByName(String filename) {
        List files = this.gridfs.find((DBObject)new BasicDBObject("filename", (Object)new BasicDBObject("$regex", (Object)(".*" + filename + ".*"))));
        ArrayList<FileInfo> toReturn = new ArrayList<FileInfo>();
        for (GridFSDBFile file : files) {
            toReturn.add(new FileInfo((GridFSFile)file, false));
        }
        return toReturn;
    }

    @Override
    public void removeByStringId(String id) throws MongoDataException {
        try {
            WriteResult result = this.getCollection().remove("{_id:#}", new Object[]{id});
            this.checkCommandResult(result);
        }
        catch (MongoException ex) {
            String msg = "Unable to remove document of type " + this.clazz.getName() + " by id '" + id + "'";
            log.error(msg, (Throwable)ex);
            throw new MongoDataException(msg, ex);
        }
    }

    protected GridFSDBFile validateObject(String storeName) throws FileNotFoundException {
        GridFSDBFile file = this.gridfs.findOne(storeName);
        if (file == null) {
            log.error("A file with name {} does not exists", (Object)storeName);
            throw new FileNotFoundException("File with file name " + storeName + " does not exist");
        }
        return file;
    }

    protected GridFSDBFile validateObject(ObjectId fileId) throws FileNotFoundException {
        GridFSDBFile file = this.gridfs.findOne(fileId);
        if (file == null) {
            log.error("A file with id {} does not exists", (Object)fileId);
            throw new FileNotFoundException("File with file name " + fileId + " does not exist");
        }
        return file;
    }

    protected T returnSimple(FindOne findOne) {
        return (T)findOne.as(this.clazz);
    }

    protected Iterable<T> returnList(Find find) {
        return find.as(this.clazz);
    }

    @Required
    public void setJongo(Jongo jongo) {
        this.jongo = jongo;
        this.gridfs = new GridFS(jongo.getDatabase());
    }

    public void setQueries(JongoQueries queries) {
        this.queries = queries;
    }

    protected String getQueryFor(String key) {
        log.trace("Trying to get query for {} ", (Object)key);
        String query = this.queries.get(key);
        log.trace("Query found {} for key {}", (Object)query, (Object)key);
        if (query == null) {
            log.error("Query for {} key does not exist", (Object)key);
            throw new IllegalArgumentException("Query for key " + key + " does not exist");
        }
        if (StringUtils.isBlank((CharSequence)query)) {
            log.error("Query for key {} can't be blank or be only whitespace", (Object)key);
            throw new IllegalArgumentException("Query for key " + key + " can't be blank or be only whitespace");
        }
        return query.trim().replaceAll("\\s+", " ");
    }

    protected String createSortQuery(List<DefaultKeyValue<String, Boolean>> fields) {
        StringBuilder builder = new StringBuilder("{");
        Iterator<DefaultKeyValue<String, Boolean>> iter = fields.iterator();
        while (iter.hasNext()) {
            DefaultKeyValue<String, Boolean> field = iter.next();
            builder.append("\"");
            builder.append((String)field.getKey());
            builder.append("\"");
            builder.append(":");
            if (((Boolean)field.getValue()).booleanValue()) {
                builder.append(1);
            } else {
                builder.append(-1);
            }
            if (!iter.hasNext()) continue;
            builder.append(",");
        }
        builder.append("}");
        return builder.toString();
    }
}

