/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.test;

import java.util.Optional;
import java.util.StringJoiner;

public class ToString {
    private final StringBuilder builder_;
    private final StringJoiner joiner_;
    private String result_;

    private ToString(Class<?> classObj) {
        this(classObj.getSimpleName());
    }

    private ToString(String className) {
        this.builder_ = new StringBuilder(className).append("[");
        this.joiner_ = new StringJoiner(",");
    }

    public static ToString builder(Class<?> type) {
        return new ToString(type);
    }

    public static ToString builder(String className) {
        return new ToString(className);
    }

    public <T> ToString add(T element) {
        return this.addIf(Optional.ofNullable(element));
    }

    public <T> ToString addIf(Optional<T> element) {
        element.ifPresent(e -> this.joiner_.add(String.valueOf(e)));
        return this;
    }

    public <T> ToString add(String name, T element) {
        return this.addIf(name, Optional.of(String.valueOf(element)));
    }

    public <T> ToString addIf(String name, Optional<T> element) {
        element.ifPresent(e -> this.joiner_.add(String.format("%s=%s", name, String.valueOf(e))));
        return this;
    }

    public String toString() {
        return this.result_ == null ? (this.result_ = this.builder_.append(this.joiner_.toString()).append("]").toString()) : this.result_;
    }
}

