/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.test;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MediaRange {
    private final String type_;
    private final String subtype_;
    private final String suffix_;
    private final Map<String, String> parameters_;
    private static final String DELIM = "\\h()<>@,;:\\\\\"/\\[\\]?={}";
    private static final String TOKEN = String.format("[^%s]+", "\\h()<>@,;:\\\\\"/\\[\\]?={}");
    private static final String STOKEN = String.format("[^%s\\+]+", "\\h()<>@,;:\\\\\"/\\[\\]?={}");
    private static final String QSTRING = "\"(?:[^\\\"]|\\\\.)*\"";
    private static final String LWS = "\\h*";
    private static final String MEDIA_RANGE = String.format("%s(%s)/(%s)(?:\\+(%s))?((?:%s;%s%s%s=%s(?:%s|%s)%s)+)?", "\\h*", TOKEN, STOKEN, STOKEN, "\\h*", "\\h*", TOKEN, "\\h*", "\\h*", TOKEN, "\"(?:[^\\\"]|\\\\.)*\"", "\\h*");
    private static final Pattern mediaRange_ = Pattern.compile(MEDIA_RANGE);
    private static final Pattern quotedChar_ = Pattern.compile("\\\\(.)");

    public static MediaRange of(String text) {
        return new MediaRange(text);
    }

    public static MediaRange anyOf(String type) {
        return MediaRange.anyOf(type, null);
    }

    public static MediaRange anyOf(String type, String suffix) {
        return new MediaRange(type, "*", suffix);
    }

    public static MediaRange any() {
        return MediaRange.anyOf("*");
    }

    private MediaRange(String text) {
        Matcher matcher = Optional.of(mediaRange_.matcher(text)).filter(Matcher::matches).orElseThrow(() -> new IllegalArgumentException(String.format("'%s' is not a valid media range", text)));
        this.type_ = matcher.group(1);
        this.subtype_ = matcher.group(2);
        this.suffix_ = matcher.group(3);
        this.parameters_ = Optional.ofNullable(matcher.group(4)).map(params -> Arrays.stream(params.split(";", 0))).orElse(Stream.empty()).map(param -> param.split("=", -1)).filter(param -> ((String[])param).length == 2).collect(Collectors.toMap(param -> param[0].trim(), param -> param[1].trim(), (v1, v2) -> v1, LinkedHashMap::new));
    }

    private MediaRange(String type, String subtype, String suffix) {
        this(MediaRange.baseType(type, subtype, suffix));
    }

    public String type() {
        return this.type_;
    }

    public String subtype() {
        return this.subtype_;
    }

    public String base() {
        return MediaRange.baseType(this.type(), this.subtype(), null);
    }

    public String baseStructured() {
        return MediaRange.baseType(this.type(), this.subtype(), this.suffix());
    }

    public String suffix() {
        return this.suffix_;
    }

    public Map<String, String> parameters() {
        return this.parameters_.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> MediaRange.quotedValueOf((String)entry.getValue())));
    }

    private static String baseType(String type, String subtype, String suffix) {
        return String.format("%s/%s%s", type, subtype, suffix == null ? "" : String.format("+%s", suffix));
    }

    private static String quotedValueOf(String value) {
        String unquoted;
        if (!value.isEmpty() && value.indexOf(34) == 0) {
            Matcher unquote = quotedChar_.matcher(value.substring(1, Math.max(value.length() - 1, 1)));
            StringBuffer result = new StringBuffer();
            while (unquote.find()) {
                unquote.appendReplacement(result, "$1");
            }
            unquote.appendTail(result);
            unquoted = result.toString();
        } else {
            unquoted = value;
        }
        return unquoted;
    }

    public String toString() {
        return MediaRange.baseType(this.type_, this.subtype_, this.suffix_) + Optional.ofNullable(this.parameters_).map(params -> params.entrySet().stream().map(param -> String.format("; %s=%s", param.getKey(), param.getValue())).collect(Collectors.joining())).orElse("");
    }
}

