/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.test;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class JsonUtils {
    private static final Pattern POINTER_ESCAPES = Pattern.compile("(~)|(/)");
    private static final Pattern POINTER_ESCAPED = Pattern.compile("(~0)|(~1)");
    private static final ObjectMapper mapper_ = new ObjectMapper();

    private JsonUtils() {
    }

    public static ObjectNode expectObject(JsonNode node) {
        return JsonUtils.isMissing(node) ? null : JsonUtils.asObject(node).orElseThrow(() -> new IllegalStateException(String.format("Expected type=OBJECT, found type=%s", node.getNodeType())));
    }

    public static Optional<ObjectNode> asObject(JsonNode node) {
        return JsonUtils.isMissing(node) ? Optional.empty() : Optional.of(node).filter(JsonNode::isObject).map(object -> (ObjectNode)object);
    }

    public static ObjectNode newObject(String field, JsonNode value) {
        return (ObjectNode)JsonUtils.createObjectNode().set(field, value);
    }

    public static ObjectNode appendObject(ObjectNode object, ObjectNode otherObject) {
        ObjectNode appended = JsonUtils.createObjectNode();
        appended.setAll(object);
        appended.setAll(otherObject);
        return appended;
    }

    public static ArrayNode expectArray(JsonNode node) {
        return JsonUtils.isMissing(node) ? null : JsonUtils.asArray(node).orElseThrow(() -> new IllegalStateException(String.format("Expected type=ARRAY, found type=%s", node.getNodeType())));
    }

    public static Optional<ArrayNode> asArray(JsonNode node) {
        return JsonUtils.isMissing(node) ? Optional.empty() : Optional.of(node).filter(JsonNode::isArray).map(array -> (ArrayNode)array);
    }

    public static ArrayNode newArray(JsonNode element) {
        return JsonUtils.createArrayNode().add(element);
    }

    public static ArrayNode appendArray(ArrayNode array, ArrayNode otherArray) {
        return JsonUtils.createArrayNode().addAll(array).addAll(otherArray);
    }

    public static boolean isMissing(JsonNode node) {
        return Optional.ofNullable(node).map(JsonNode::isMissingNode).orElse(true);
    }

    public static boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static JsonPointer pointer(String ... path) {
        return JsonUtils.pointer(Arrays.asList(path));
    }

    public static JsonPointer pointer(Iterable<String> path) {
        StringJoiner joiner = new StringJoiner("/", "/", "");
        for (String name : path) {
            joiner.add(JsonUtils.pointerSegment(name));
        }
        return JsonPointer.compile((String)joiner.toString());
    }

    private static String pointerSegment(String name) {
        Matcher matcher = POINTER_ESCAPES.matcher(name);
        StringBuffer escaped = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(escaped, matcher.group(1) != null ? "~0" : "~1");
        }
        matcher.appendTail(escaped);
        return escaped.toString();
    }

    public static String tailOf(JsonPointer pointer) {
        return Optional.of(JsonUtils.pathOf(pointer)).filter(path -> !path.isEmpty()).map(path -> (String)path.get(path.size() - 1)).orElse("");
    }

    public static List<String> pathOf(JsonPointer pointer) {
        String[] segments = String.valueOf(pointer).split("/", 0);
        return IntStream.range(1, segments.length).mapToObj(i -> JsonUtils.pathElementOf(segments[i])).collect(Collectors.toList());
    }

    private static String pathElementOf(String segment) {
        Matcher matcher = POINTER_ESCAPED.matcher(segment);
        StringBuffer unescaped = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(unescaped, matcher.group(1) != null ? "~" : "/");
        }
        matcher.appendTail(unescaped);
        return unescaped.toString();
    }

    public static ObjectNode createObjectNode() {
        return JsonUtils.mapper().createObjectNode();
    }

    public static ArrayNode createArrayNode() {
        return JsonUtils.mapper().createArrayNode();
    }

    public static ObjectMapper mapper() {
        return mapper_;
    }

    public static JsonNode readJson(String content) throws IOException {
        return JsonUtils.readJson(new StringReader(content));
    }

    public static JsonNode readJson(Reader content) throws IOException {
        return JsonUtils.mapper().readTree(content);
    }
}

