/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.test;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.cornutum.tcases.openapi.test.HeaderDef;
import org.cornutum.tcases.openapi.test.ToString;

public class EncodingDef {
    private final String style_;
    private final Boolean exploded_;
    private final String contentType_;
    private final List<HeaderDef> headers_;

    public static EncodingDef forSimpleValue(Boolean exploded) {
        return EncodingDef.forSimpleValue("simple", exploded);
    }

    public static EncodingDef forSimpleValue(String style, Boolean exploded) {
        return new EncodingDef(style, Optional.ofNullable(exploded).orElse(false), null, null);
    }

    public static EncodingDef forUrlEncodedForm(String style, Boolean exploded) {
        String styleApplied = Optional.ofNullable(style).orElse("form");
        boolean explodedApplied = Optional.ofNullable(exploded).orElse("form".equals(styleApplied));
        return new EncodingDef(styleApplied, explodedApplied, null, null);
    }

    public static EncodingDef forUrlEncodedForm() {
        return EncodingDef.forUrlEncodedForm(null, null);
    }

    public static EncodingDef forMultipartForm(String contentType, List<HeaderDef> headers) {
        return new EncodingDef(null, null, contentType, headers);
    }

    private EncodingDef(String style, Boolean exploded, String contentType, List<HeaderDef> headers) {
        this.style_ = style;
        this.exploded_ = exploded;
        this.contentType_ = contentType;
        this.headers_ = Optional.ofNullable(headers).orElse(Collections.emptyList());
    }

    public String getStyle() {
        return this.style_;
    }

    public Boolean isExploded() {
        return this.exploded_;
    }

    public String getContentType() {
        return this.contentType_;
    }

    public List<HeaderDef> getHeaders() {
        return this.headers_;
    }

    public String toString() {
        return ToString.builder(this.getClass()).addIf("style", Optional.ofNullable(this.getStyle())).addIf("exploded", Optional.ofNullable(this.isExploded())).addIf("contentType", Optional.ofNullable(this.getContentType())).toString();
    }
}

