/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.test;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> Stream<T> toStream(Iterator<T> iterator) {
        return Optional.ofNullable(iterator).map(i -> {
            Iterable iterable = () -> i;
            return CollectionUtils.toStream(iterable);
        }).orElse(null);
    }

    public static <T> Stream<T> toStream(Iterable<T> iterable) {
        return Optional.ofNullable(iterable).map(i -> StreamSupport.stream(i.spliterator(), false)).orElse(null);
    }

    public static <T, K, V> Collector<T, ?, Map<K, V>> toOrderedMap(Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, (v1, v2) -> v1, LinkedHashMap::new);
    }

    public static <K, V> Map.Entry<K, V> mapping(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    @SafeVarargs
    public static <T> List<T> concatList(List<T> head, T ... tail) {
        return Stream.concat(Optional.ofNullable(head).map(Collection::stream).orElse(Stream.empty()), Arrays.stream(tail)).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <T> Stream<T> concatStream(Stream<T> ... streams) {
        return CollectionUtils.concatStream(Arrays.asList(streams));
    }

    public static <T> Stream<T> concatStream(List<Stream<T>> streams) {
        return streams.isEmpty() ? Stream.empty() : Stream.concat(streams.get(0), CollectionUtils.concatStream(streams.subList(1, streams.size())));
    }
}

