/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.test;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cornutum.tcases.openapi.test.EncodingDef;

public abstract class AbstractDecoder {
    private final EncodingDef encodingDef_;

    protected AbstractDecoder(EncodingDef encodingDef) {
        this.encodingDef_ = Optional.ofNullable(encodingDef).orElse(EncodingDef.forSimpleValue(false));
    }

    public boolean isExploded() {
        return this.getEncodingDef().isExploded();
    }

    public String getStyle() {
        return this.getEncodingDef().getStyle();
    }

    public EncodingDef getEncodingDef() {
        return this.encodingDef_;
    }

    public List<JsonNode> decode(String content) {
        return Arrays.asList(this.decodeObject(content), this.decodeArray(content), this.decodeValue(content)).stream().flatMap(jsons -> jsons.stream()).collect(Collectors.toList());
    }

    public abstract List<JsonNode> decodeObject(String var1);

    public abstract List<JsonNode> decodeArray(String var1);

    public List<JsonNode> decodeValue(String content) {
        return Arrays.asList(this.decodeNumber(content), this.decodeBoolean(content), this.decodeString(content), this.decodeNull(content)).stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Optional<JsonNode> decodeNumber(String content) {
        JsonNode jsonNode;
        try {
            BigInteger integer;
            BigDecimal number = new BigDecimal(content);
            try {
                integer = Optional.of(number).filter(decimal -> decimal.scale() == 0).map(BigDecimal::toBigIntegerExact).orElse(null);
            }
            catch (Exception e) {
                integer = null;
            }
            jsonNode = Optional.ofNullable(integer).map(i -> BigIntegerNode.valueOf((BigInteger)i)).orElse((JsonNode)DecimalNode.valueOf((BigDecimal)number));
        }
        catch (Exception e) {
            jsonNode = null;
        }
        return Optional.ofNullable(jsonNode);
    }

    public Optional<JsonNode> decodeBoolean(String content) {
        return Optional.ofNullable(content).filter(text -> "true".equals(text) || "false".equals(text)).map(text -> BooleanNode.valueOf((boolean)Boolean.valueOf(text)));
    }

    public Optional<JsonNode> decodeString(String content) {
        return Optional.ofNullable(content).map(text -> TextNode.valueOf((String)text));
    }

    public Optional<JsonNode> decodeNull(String content) {
        return Optional.of(Objects.toString(content, "")).filter(String::isEmpty).map(empty -> NullNode.instance);
    }

    protected String decodeUrl(String content) {
        try {
            return content == null ? null : URLDecoder.decode(content, "UTF-8");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Can't decode application/x-www-form-urlencoded content=%s", content), e);
        }
    }
}

