/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.test;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.cornutum.tcases.openapi.test.AbstractDecoder;
import org.cornutum.tcases.openapi.test.CollectionUtils;
import org.cornutum.tcases.openapi.test.EncodingDef;
import org.cornutum.tcases.openapi.test.JsonUtils;

public class SimpleDecoder
extends AbstractDecoder {
    private final String delimiter_ = "pipeDelimited".equals(this.getStyle()) ? "\\|" : ("spaceDelimited".equals(this.getStyle()) ? " " : ",");

    public SimpleDecoder(EncodingDef encoding) {
        super(encoding);
    }

    @Override
    public List<JsonNode> decodeObject(String content) {
        return Optional.ofNullable(content).map(text -> text.isEmpty() ? new String[]{} : text.split(this.delimiter_, -1)).filter(members -> this.isExploded() || ((String[])members).length % 2 == 0).map(members -> {
            List properties = !this.isExploded() ? IntStream.range(0, ((String[])members).length / 2).mapToObj(i -> CollectionUtils.mapping(members[2 * i], members[2 * i + 1])).collect(Collectors.toList()) : (List)Optional.of(Arrays.stream(members).map(member -> member.split("=", -1)).collect(Collectors.toList())).filter(pairs -> pairs.stream().allMatch(pair -> ((String[])pair).length == 2)).map(mappings -> mappings.stream().map(mapping -> CollectionUtils.mapping(mapping[0], mapping[1])).collect(Collectors.toList())).orElse(null);
            return Optional.ofNullable(properties).map(mappings -> this.decodeObject((List<Map.Entry<String, String>>)mappings)).orElse(Collections.emptyList());
        }).orElse(Collections.emptyList());
    }

    private List<JsonNode> decodeObject(List<Map.Entry<String, String>> properties) {
        return properties.isEmpty() ? Collections.singletonList(JsonUtils.createObjectNode()) : this.decodeValue(properties.get(0).getValue()).stream().map(jsonNode -> JsonUtils.newObject((String)((Map.Entry)properties.get(0)).getKey(), jsonNode)).flatMap(firstProperty -> this.decodeObject(properties.subList(1, properties.size())).stream().map(JsonUtils::expectObject).map(otherProperties -> JsonUtils.appendObject(firstProperty, otherProperties))).collect(Collectors.toList());
    }

    @Override
    public List<JsonNode> decodeArray(String content) {
        return Optional.ofNullable(content).map(text -> text.isEmpty() ? new String[]{} : text.split(this.delimiter_, -1)).map(members -> this.decodeArray((String[])members)).orElse(Collections.emptyList());
    }

    private List<JsonNode> decodeArray(String[] members) {
        return members.length == 0 ? Collections.singletonList(JsonUtils.createArrayNode()) : this.decodeValue(members[0]).stream().map(jsonNode -> JsonUtils.newArray(jsonNode)).flatMap(firstMember -> this.decodeArray(Arrays.copyOfRange(members, 1, members.length)).stream().map(JsonUtils::expectArray).map(otherMembers -> JsonUtils.appendArray(firstMember, otherMembers))).collect(Collectors.toList());
    }
}

