/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.test;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cornutum.tcases.openapi.test.CollectionUtils;
import org.cornutum.tcases.openapi.test.ContentDef;
import org.cornutum.tcases.openapi.test.EncodingDef;
import org.cornutum.tcases.openapi.test.HeaderDef;
import org.cornutum.tcases.openapi.test.JsonUtils;
import org.cornutum.tcases.openapi.test.MediaRange;
import org.cornutum.tcases.openapi.test.ToString;

public class ResponsesDef {
    private final ObjectNode root_;

    public ResponsesDef(ObjectNode root) {
        this.root_ = root;
    }

    public ResponsesDef forPaths(Collection<String> paths) {
        ObjectNode view = JsonUtils.createObjectNode();
        Optional<Collection> includedPaths = Optional.ofNullable(paths).filter(p -> !p.isEmpty());
        CollectionUtils.toStream(this.root_.fieldNames()).filter(path -> includedPaths.map(includes -> includes.stream().anyMatch(include -> path.equalsIgnoreCase((String)include))).orElse(true)).forEach(path -> view.set(path, this.root_.get(path)));
        return new ResponsesDef(view);
    }

    public ResponsesDef forPaths(String ... paths) {
        return this.forPaths(Arrays.asList(paths));
    }

    public ResponsesDef forOps(Collection<String> ops) {
        ObjectNode view = JsonUtils.createObjectNode();
        Optional<Collection> includedOps = Optional.ofNullable(ops).filter(o -> !o.isEmpty());
        CollectionUtils.toStream(this.root_.fields()).collect(CollectionUtils.toOrderedMap(pathDef -> (String)pathDef.getKey(), pathDef -> {
            ObjectNode opsDef = (ObjectNode)pathDef.getValue();
            ObjectNode opsView = JsonUtils.createObjectNode();
            CollectionUtils.toStream(opsDef.fieldNames()).filter(op -> includedOps.map(includes -> includes.stream().anyMatch(include -> op.equalsIgnoreCase((String)include))).orElse(true)).forEach(op -> opsView.set(op, opsDef.get(op)));
            return opsView;
        })).forEach((path, opsView) -> view.set(path, (JsonNode)opsView));
        return new ResponsesDef(view);
    }

    public ResponsesDef forOps(String ... ops) {
        return this.forOps(Arrays.asList(ops));
    }

    public List<String> paths() {
        return CollectionUtils.toStream(this.root_.fieldNames()).collect(Collectors.toList());
    }

    public List<String> ops(String path) {
        return CollectionUtils.toStream(this.pathDef(path).fieldNames()).collect(Collectors.toList());
    }

    public ObjectNode pathDef(String path) {
        return (ObjectNode)this.root_.get(path);
    }

    public ObjectNode opDef(String op, String path) {
        return (ObjectNode)this.pathDef(path).get(op);
    }

    public boolean defined(String op, String path, int statusCode) {
        return this.opStatusResponse(op, path, statusCode).isPresent();
    }

    public boolean hasBody(String op, String path, int statusCode) {
        return this.opStatusContent(op, path, statusCode).isPresent();
    }

    public Optional<ContentDef> bodyContentDef(String op, String path, int statusCode, String contentType) {
        return this.opStatusContent(op, path, statusCode, contentType).map(content -> new ContentDef(contentType, JsonUtils.expectObject(content.get("schema")), null, this.contentEncodings(contentType, (JsonNode)content)));
    }

    private Map<String, EncodingDef> contentEncodings(String contentType, JsonNode content) {
        return Optional.ofNullable(JsonUtils.expectObject(content.get("encoding"))).map(encodings -> CollectionUtils.toStream(encodings.fields())).orElse(Stream.empty()).collect(CollectionUtils.toOrderedMap(encoding -> (String)encoding.getKey(), encoding -> this.contentEncodingDef(contentType, JsonUtils.expectObject((JsonNode)encoding.getValue()))));
    }

    private EncodingDef contentEncodingDef(String mediaType, ObjectNode encoding) {
        String style = Optional.ofNullable(encoding.get("style")).map(JsonNode::asText).orElse(null);
        Boolean exploded = Optional.ofNullable(encoding.get("explode")).map(JsonNode::asBoolean).orElse(null);
        String contentType = Optional.ofNullable(encoding.get("contentType")).map(JsonNode::asText).orElse(null);
        List<HeaderDef> headers = this.contentHeaders(encoding);
        return "multipart/form-data".equals(mediaType) ? EncodingDef.forMultipartForm(contentType, headers) : EncodingDef.forUrlEncodedForm(style, exploded);
    }

    public List<HeaderDef> headerDefs(String op, String path, int statusCode) {
        return this.opStatusResponse(op, path, statusCode).map(this::contentHeaders).orElse(Collections.emptyList());
    }

    private ObjectNode opResponses(String op, String path) {
        return this.objectAt(path, op.toLowerCase()).orElseThrow(() -> new IllegalArgumentException(String.format("%s %s: no OpenAPI response definitions found", op, path)));
    }

    private Optional<ObjectNode> opStatusContent(String op, String path, int statusCode) {
        return this.opStatusResponse(op, path, statusCode).flatMap(response -> Optional.ofNullable(JsonUtils.expectObject(response.get("content")))).filter(content -> content.size() > 0);
    }

    private Optional<ObjectNode> opStatusContent(String op, String path, int statusCode, String contentType) {
        return this.opStatusContent(op, path, statusCode).flatMap(content -> {
            MediaRange media = MediaRange.of(contentType);
            Object[] alternatives = new Object[]{contentType, media.baseStructured(), MediaRange.anyOf(media.type(), media.suffix()), media.base(), MediaRange.anyOf(media.type()), MediaRange.any()};
            return Arrays.stream(alternatives).map(type -> JsonUtils.expectObject(content.get(String.valueOf(type)))).filter(Objects::nonNull).findFirst();
        });
    }

    private List<HeaderDef> contentHeaders(ObjectNode content) {
        return Optional.ofNullable(JsonUtils.expectObject(content.get("headers"))).map(headers -> CollectionUtils.toStream(headers.fields())).orElse(Stream.empty()).map(headerDef -> {
            String name = (String)headerDef.getKey();
            ObjectNode def = JsonUtils.expectObject((JsonNode)headerDef.getValue());
            Boolean required = Optional.ofNullable(def.get("required")).map(JsonNode::asBoolean).orElse(null);
            Boolean exploded = Optional.ofNullable(def.get("explode")).map(JsonNode::asBoolean).orElse(null);
            Optional<ObjectNode> contentDef = Optional.ofNullable(JsonUtils.expectObject(def.get("content")));
            String contentType = contentDef.map(ObjectNode::fieldNames).flatMap(contentTypes -> CollectionUtils.toStream(contentTypes).findFirst()).orElse("text/plain");
            Optional<ObjectNode> headerContent = contentDef.map(c -> JsonUtils.expectObject(c.get(contentType)));
            ObjectNode schema = headerContent.map(c -> JsonUtils.expectObject(c.get("schema"))).orElse(JsonUtils.expectObject(def.get("schema")));
            Map<String, EncodingDef> propertyEncodings = headerContent.map(hc -> this.contentEncodings(contentType, (JsonNode)hc)).orElse(Collections.emptyMap());
            EncodingDef valueEncoding = EncodingDef.forSimpleValue(exploded);
            return new HeaderDef(name, required, new ContentDef(contentType, schema, valueEncoding, propertyEncodings));
        }).collect(Collectors.toList());
    }

    private Optional<ObjectNode> opStatusResponse(String op, String path, int statusCode) {
        ObjectNode opResponses = this.opResponses(op, path);
        String statusKey = String.valueOf(statusCode);
        String statusRangeKey = String.format("%sXX", statusKey.substring(0, 1));
        return Arrays.asList(statusKey, statusRangeKey, "default").stream().map(key -> JsonUtils.expectObject(opResponses.get(key))).filter(Objects::nonNull).findFirst();
    }

    private Optional<ObjectNode> objectAt(String ... path) {
        return Optional.ofNullable(JsonUtils.expectObject(this.root_.at(JsonUtils.pointer(path))));
    }

    public static void write(ResponsesDef responses, Writer writer) {
        try (JsonGenerator generator = JsonUtils.mapper().writerWithDefaultPrettyPrinter().createGenerator(writer);){
            JsonUtils.mapper().writeTree(generator, (JsonNode)responses.root_);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't write JSON document", e);
        }
    }

    public static ResponsesDef read(Reader reader) {
        try {
            return new ResponsesDef((ObjectNode)Optional.of(JsonUtils.readJson(reader)).flatMap(root -> JsonUtils.asObject(root)).orElseThrow(() -> new IllegalStateException("Expected JSON type=object")));
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't read JSON document", e);
        }
    }

    public String toString() {
        return ToString.builder(this.getClass()).toString();
    }

    public boolean equals(Object object) {
        ResponsesDef other = object != null && object.getClass().equals(this.getClass()) ? (ResponsesDef)object : null;
        return other != null && Objects.equals(other.root_, this.root_);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ Objects.hashCode(this.root_);
    }
}

