/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.test;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cornutum.tcases.openapi.test.ContentDef;
import org.cornutum.tcases.openapi.test.FormUrlDecoder;
import org.cornutum.tcases.openapi.test.JsonUtils;
import org.cornutum.tcases.openapi.test.MediaRange;
import org.cornutum.tcases.openapi.test.ResponseAnalyzer;
import org.cornutum.tcases.openapi.test.ResponseUnvalidatedException;
import org.cornutum.tcases.openapi.test.ResponseValidationException;
import org.cornutum.tcases.openapi.test.ResponseValidationHandler;
import org.cornutum.tcases.openapi.test.ResponsesDef;
import org.cornutum.tcases.openapi.test.SchemaValidationError;
import org.cornutum.tcases.openapi.test.SimpleDecoder;
import org.cornutum.tcases.openapi.test.ToString;

public class ResponseValidator {
    private final ResponsesDef responses_;
    private ResponseValidationHandler validationHandler_ = ResponseValidationHandler.EXPECT_CONFORM;
    private boolean writeOnlyInvalid_ = true;

    public ResponseValidator(Class<?> testClass) {
        this(testClass, String.format("%s-Responses.json", testClass.getSimpleName()));
    }

    public ResponseValidator(Class<?> testClass, String resourceName) {
        this(ResponseValidator.streamFor(testClass, resourceName));
        this.notifying(this.validationHandlerFor(testClass).orElse(null));
    }

    public ResponseValidator(InputStream responses) {
        this(ResponseValidator.readerFor(responses));
    }

    public ResponseValidator(Reader responses) {
        this.writeOnlyInvalid(this.writeOnlyInvalid().orElse(true));
        try {
            this.responses_ = ResponsesDef.read(responses);
        }
        finally {
            try {
                responses.close();
            }
            catch (Exception exception) {}
        }
    }

    public ResponseValidator notifying(ResponseValidationHandler handler) {
        this.validationHandler_ = Optional.ofNullable(handler).orElse(ResponseValidationHandler.EXPECT_CONFORM);
        return this;
    }

    public ResponseValidator writeOnlyInvalid(boolean invalid) {
        this.writeOnlyInvalid_ = invalid;
        return this;
    }

    public boolean isWriteOnlyInvalid() {
        return this.writeOnlyInvalid_;
    }

    public void assertBodyValid(String op, String path, int statusCode, String contentType, String content) {
        block12: {
            try {
                Optional<List<SchemaValidationError>> validationErrors;
                if (!this.responses_.defined(op, path, statusCode)) {
                    throw new ResponseValidationException(op, path, String.format("no response defined for statusCode=%s", statusCode));
                }
                String bodyContentType = Objects.toString(contentType, "").trim();
                String bodyContent = Objects.toString(content, "").trim();
                boolean bodyExpected = this.responses_.hasBody(op, path, statusCode);
                if (bodyExpected) {
                    if (bodyContentType.isEmpty()) {
                        throw new ResponseValidationException(op, path, statusCode, "body", "no response Content-Type header received");
                    }
                } else {
                    if (!bodyContentType.isEmpty()) {
                        throw new ResponseValidationException(op, path, statusCode, "body", "unexpected response Content-Type header received");
                    }
                    if (!bodyContent.isEmpty()) {
                        throw new ResponseValidationException(op, path, statusCode, "body", "unexpected response body received");
                    }
                }
                if (!bodyExpected) break block12;
                ContentDef bodyContentDef = this.responses_.bodyContentDef(op, path, statusCode, bodyContentType).orElseThrow(() -> new ResponseValidationException(op, path, statusCode, "body", String.format("unexpected response contentType=%s", bodyContentType)));
                List<JsonNode> bodyContentJson = this.bodyContentJson(op, path, statusCode, bodyContentDef, bodyContent);
                if (bodyContentJson.isEmpty()) {
                    throw new ResponseUnvalidatedException(op, path, statusCode, "body", String.format("contentType=%s can't be validated", bodyContentType));
                }
                JsonNode schema = (JsonNode)Optional.ofNullable(bodyContentDef.getSchema()).orElseThrow(() -> new ResponseUnvalidatedException(op, path, statusCode, "body", String.format("no schema defined for contentType=%s", bodyContentType)));
                try {
                    validationErrors = ResponseAnalyzer.validate(schema, bodyContentJson, this.isWriteOnlyInvalid());
                }
                catch (Exception e) {
                    throw new ResponseValidationException(op, path, statusCode, "body", "can't validate content", e);
                }
                validationErrors.ifPresent(errors -> this.reportValidationErrors(op, path, statusCode, "body", "invalid response", (List<SchemaValidationError>)errors));
            }
            catch (ResponseUnvalidatedException unvalidated) {
                this.notify(unvalidated);
            }
            catch (ResponseValidationException invalid) {
                this.notify(invalid);
            }
        }
    }

    public void assertHeadersValid(String op, String path, int statusCode, Map<String, String> headers) {
        try {
            if (!this.responses_.defined(op, path, statusCode)) {
                throw new ResponseValidationException(op, path, String.format("no response defined for statusCode=%s", statusCode));
            }
            this.responses_.headerDefs(op, path, statusCode).forEach(headerDef -> {
                String headerName = headerDef.getName();
                if (!"Content-Type".equals(headerName)) {
                    if (headers.containsKey(headerName)) {
                        Optional<List<SchemaValidationError>> validationErrors;
                        ContentDef headerContentDef = headerDef.getContentDef();
                        ObjectNode schema = Optional.ofNullable(headerContentDef.getSchema()).orElseThrow(() -> new ResponseUnvalidatedException(op, path, statusCode, headerName, "no schema defined"));
                        List<JsonNode> headerContentJson = this.contentJson(op, path, statusCode, headerName, headerContentDef, (String)headers.get(headerName));
                        if (headerContentJson.isEmpty()) {
                            throw new ResponseUnvalidatedException(op, path, statusCode, headerName, String.format("contentType=%s can't be validated", headerContentDef.getContentType()));
                        }
                        try {
                            validationErrors = ResponseAnalyzer.validate((JsonNode)schema, headerContentJson, this.isWriteOnlyInvalid());
                        }
                        catch (Exception e) {
                            throw new ResponseValidationException(op, path, statusCode, headerName, "can't validate value", e);
                        }
                        validationErrors.ifPresent(errors -> this.reportValidationErrors(op, path, statusCode, headerName, "invalid value", (List<SchemaValidationError>)errors));
                    } else if (headerDef.isRequired()) {
                        throw new ResponseValidationException(op, path, statusCode, headerName, "required header not received");
                    }
                }
            });
        }
        catch (ResponseUnvalidatedException unvalidated) {
            this.notify(unvalidated);
        }
        catch (ResponseValidationException invalid) {
            this.notify(invalid);
        }
    }

    private List<JsonNode> bodyContentJson(String op, String path, int statusCode, ContentDef contentDef, String bodyContent) {
        return this.contentJson(op, path, statusCode, "body", contentDef, bodyContent);
    }

    private List<JsonNode> contentJson(String op, String path, int statusCode, String location, ContentDef contentDef, String content) {
        String contentType = contentDef.getContentType();
        try {
            MediaRange media = MediaRange.of(contentType);
            return Optional.ofNullable("application/json".equals(media.base()) || "json".equals(media.suffix()) ? Optional.of(this.decodeJson(content)).filter(json -> json.stream().noneMatch(JsonNode::isMissingNode)).orElseThrow(() -> new IllegalArgumentException("No JSON content found")) : ("text/plain".equals(media.base()) ? this.decodeSimple(content, contentDef) : ("application/x-www-form-urlencoded".equals(media.base()) ? this.decodeFormUrl(content, contentDef) : null))).orElse(Collections.emptyList());
        }
        catch (Exception e) {
            throw new ResponseValidationException(op, path, statusCode, location, String.format("Can't decode as contentType=%s", contentType), e);
        }
    }

    private List<JsonNode> decodeJson(String content) throws Exception {
        return Collections.singletonList(JsonUtils.readJson(content));
    }

    private List<JsonNode> decodeSimple(String content, ContentDef contentDef) throws Exception {
        return new SimpleDecoder(contentDef.getValueEncoding()).decode(content);
    }

    private List<JsonNode> decodeFormUrl(String content, ContentDef contentDef) throws Exception {
        return new FormUrlDecoder(contentDef).decode(content);
    }

    private void notify(ResponseUnvalidatedException unvalidated) {
        this.validationHandler_.handleUnvalidated(unvalidated);
    }

    private void notify(ResponseValidationException invalid) {
        this.validationHandler_.handleInvalid(invalid);
    }

    private void reportValidationErrors(String op, String path, int statusCode, String location, String reason, List<SchemaValidationError> errors) {
        throw new ResponseValidationException(op, path, statusCode, location, String.format("%s\n%s", reason, errors.stream().map(Object::toString).collect(Collectors.joining("\n"))));
    }

    private static Reader readerFor(InputStream stream) {
        try {
            return new InputStreamReader(stream, "UTF-8");
        }
        catch (Exception e) {
            throw new ResponseValidationException("Can't read response definitions", e);
        }
    }

    private static InputStream streamFor(Class<?> testClass, String resourceName) {
        InputStream responses;
        String resourceDir = Objects.toString(System.getProperty("tcasesApiResourceDir"), "").trim();
        if (!resourceDir.isEmpty()) {
            File resourceFile = new File(resourceDir, resourceName);
            try {
                responses = new FileInputStream(resourceFile);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can't read response definitions from " + resourceFile, e);
            }
        } else {
            responses = Optional.ofNullable(testClass.getResourceAsStream(resourceName)).orElseThrow(() -> new IllegalArgumentException(String.format("Can't find resource=%s for class=%s", resourceName, testClass.getName())));
        }
        return responses;
    }

    private Optional<ResponseValidationHandler> validationHandlerFor(Class<?> testClass) {
        return Optional.of(Objects.toString(System.getProperty("tcasesApiValidationHandler"), "").trim()).filter(className -> !className.isEmpty()).map(className -> {
            ResponseValidationHandler handler;
            block4: {
                String fqn = className.indexOf(46) >= 0 ? className : String.format("%s.%s", testClass.getPackage().getName(), className);
                try {
                    Class<ResponseValidationHandler> handlerClass = Class.forName(fqn);
                    Constructor<ResponseValidationHandler> handlerConstructor = this.handlerConstructor(handlerClass, Class.class);
                    if (handlerConstructor != null) {
                        handler = handlerConstructor.newInstance(testClass);
                        break block4;
                    }
                    handlerConstructor = this.handlerConstructor(handlerClass, new Class[0]);
                    if (handlerConstructor != null) {
                        handler = handlerConstructor.newInstance(new Object[0]);
                        break block4;
                    }
                    throw new IllegalArgumentException(String.format("Can't get constructor for class=%s", fqn));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Can't create instance of class=%s", fqn), e);
                }
            }
            return handler;
        });
    }

    private Optional<Boolean> writeOnlyInvalid() {
        return Optional.of(Objects.toString(System.getProperty("tcasesApiWriteOnlyInvalid"), "").trim()).filter(invalid -> !invalid.isEmpty()).map(invalid -> Boolean.valueOf(invalid));
    }

    private Constructor<ResponseValidationHandler> handlerConstructor(Class<ResponseValidationHandler> handlerClass, Class<?> ... argTypes) {
        try {
            return handlerClass.getConstructor(argTypes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        return ToString.builder(this.getClass()).add(this.validationHandler_).addIf("writeOnlyInvalid", Optional.of(this.writeOnlyInvalid_).filter(woi -> woi == false)).toString();
    }
}

