/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.test;

import java.util.Objects;
import java.util.Optional;

public class ResponseValidationException
extends RuntimeException {
    private final String op_;
    private final String path_;
    private final Integer statusCode_;
    private final String location_;
    private static final long serialVersionUID = 5626606510307898664L;

    public ResponseValidationException(String reason) {
        this(reason, null);
    }

    public ResponseValidationException(String reason, Throwable cause) {
        this(null, null, null, null, reason, cause);
    }

    public ResponseValidationException(String op, String path, String reason) {
        this(op, path, null, null, reason);
    }

    public ResponseValidationException(String op, String path, Integer statusCode, String location, String reason) {
        this(op, path, statusCode, location, reason, null);
    }

    public ResponseValidationException(String op, String path, Integer statusCode, String location, String reason, Throwable cause) {
        super(ResponseValidationException.messageFor(op, path, statusCode, location, reason), cause);
        this.op_ = op;
        this.path_ = path;
        this.statusCode_ = statusCode;
        this.location_ = location;
    }

    public String getOperation() {
        return this.op_;
    }

    public String getPath() {
        return this.path_;
    }

    public String getLocation() {
        return this.location_;
    }

    public Integer getStatusCode() {
        return this.statusCode_;
    }

    public static String messageFor(String op, String path, Integer statusCode, String location, String message) {
        String prefix = String.format("%s%s%s%s", Objects.toString(op, ""), Optional.ofNullable(path).map(p -> String.format(" %s", p)).orElse(""), Optional.ofNullable(statusCode).map(c -> String.format(" (%s)", c)).orElse(""), Optional.ofNullable(location).map(l -> String.format(", %s", l)).orElse(""));
        return String.format("%s%s", Optional.of(prefix).map(p -> String.format("%s: ", p)).orElse(""), message);
    }
}

