/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.test;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.cornutum.tcases.openapi.test.CollectionUtils;
import org.cornutum.tcases.openapi.test.JsonUtils;
import org.cornutum.tcases.openapi.test.SchemaValidationError;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.schema.validator.ValidationData;
import org.openapi4j.schema.validator.v3.SchemaValidator;

public final class ResponseAnalyzer {
    private ResponseAnalyzer(JsonNode schema, List<JsonNode> content) {
    }

    public static List<JsonPointer> schemaWriteOnly(JsonNode schema) {
        return ResponseAnalyzer.schemaWriteOnly(Collections.emptyList(), schema);
    }

    private static List<JsonPointer> schemaWriteOnly(List<String> location, JsonNode schema) {
        Map<Boolean, List<Map.Entry>> propertiesByWriteOnly = JsonUtils.asObject(schema.get("properties")).map(properties -> CollectionUtils.toStream(properties.fields())).orElse(Stream.empty()).collect(Collectors.groupingBy(e -> Optional.ofNullable(((JsonNode)e.getValue()).get("writeOnly")).map(JsonNode::asBoolean).orElse(false)));
        List writeOnly = Optional.ofNullable(propertiesByWriteOnly.get(true)).orElse(Collections.emptyList()).stream().map(e -> JsonUtils.pointer(CollectionUtils.concatList(location, "properties", (String)e.getKey()))).collect(Collectors.toList());
        List propertiesWriteOnly = Optional.ofNullable(propertiesByWriteOnly.get(false)).orElse(Collections.emptyList()).stream().flatMap(e -> ResponseAnalyzer.schemaWriteOnly(CollectionUtils.concatList(location, "properties", (String)e.getKey()), (JsonNode)e.getValue()).stream()).collect(Collectors.toList());
        List additionalPropertiesWriteOnly = JsonUtils.asObject(schema.get("additionalProperties")).map(additionalProperties -> ResponseAnalyzer.schemaWriteOnly(CollectionUtils.concatList(location, "additionalProperties"), (JsonNode)additionalProperties)).orElse(Collections.emptyList());
        List itemsWriteOnly = JsonUtils.asObject(schema.get("items")).map(items -> ResponseAnalyzer.schemaWriteOnly(CollectionUtils.concatList(location, "items"), (JsonNode)items)).orElse(Collections.emptyList());
        List allOfWriteOnly = JsonUtils.asArray(schema.get("allOf")).map(allOf -> IntStream.range(0, allOf.size()).mapToObj(i -> ResponseAnalyzer.schemaWriteOnly(CollectionUtils.concatList(location, "allOf", String.valueOf(i)), allOf.get(i))).flatMap(Collection::stream).collect(Collectors.toList())).orElse(Collections.emptyList());
        List anyOfWriteOnly = JsonUtils.asArray(schema.get("anyOf")).map(anyOf -> IntStream.range(0, anyOf.size()).mapToObj(i -> ResponseAnalyzer.schemaWriteOnly(CollectionUtils.concatList(location, "anyOf", String.valueOf(i)), anyOf.get(i))).flatMap(Collection::stream).collect(Collectors.toList())).orElse(Collections.emptyList());
        List oneOfWriteOnly = JsonUtils.asArray(schema.get("oneOf")).map(oneOf -> IntStream.range(0, oneOf.size()).mapToObj(i -> ResponseAnalyzer.schemaWriteOnly(CollectionUtils.concatList(location, "oneOf", String.valueOf(i)), oneOf.get(i))).flatMap(Collection::stream).collect(Collectors.toList())).orElse(Collections.emptyList());
        return CollectionUtils.concatStream(writeOnly.stream(), propertiesWriteOnly.stream(), additionalPropertiesWriteOnly.stream(), itemsWriteOnly.stream(), allOfWriteOnly.stream(), anyOfWriteOnly.stream(), oneOfWriteOnly.stream()).collect(Collectors.toList());
    }

    public static List<JsonPointer> contentWriteOnly(JsonNode content, List<JsonPointer> schemaWriteOnly) {
        return schemaWriteOnly.stream().flatMap(location -> ResponseAnalyzer.matchesAt(content, location).stream()).filter(location -> !content.at(location).isMissingNode()).collect(Collectors.toList());
    }

    public static JsonNode schemaWithoutWriteOnly(JsonNode schema, List<JsonPointer> schemaWriteOnly) {
        schemaWriteOnly.forEach(location -> {
            String property = JsonUtils.tailOf(location);
            JsonPointer locationProperties = location.head();
            ObjectNode objectSchema = JsonUtils.expectObject(schema.at(locationProperties.head()));
            if (objectSchema.has("required")) {
                objectSchema.set("required", (JsonNode)JsonUtils.createArrayNode().addAll((Collection)CollectionUtils.toStream(objectSchema.get("required").elements()).filter(required -> !property.equals(required.asText())).collect(Collectors.toList())));
            }
        });
        return schema;
    }

    public static JsonNode contentWithoutWriteOnly(JsonNode content, List<JsonPointer> contentWriteOnly) {
        contentWriteOnly.forEach(location -> {
            JsonPointer locationProperties = location.head();
            ObjectNode properties = JsonUtils.expectObject(content.at(locationProperties));
            String property = JsonUtils.tailOf(location);
            properties.remove(property);
        });
        return content;
    }

    public static Optional<List<SchemaValidationError>> validate(JsonNode schema, List<JsonNode> contentAlternatives, boolean writeOnlyInvalid) throws Exception {
        List contentInvalid;
        List<JsonPointer> schemaWriteOnly = writeOnlyInvalid ? ResponseAnalyzer.schemaWriteOnly(schema) : Collections.emptyList();
        JsonNode schemaWithoutWriteOnly = ResponseAnalyzer.schemaWithoutWriteOnly(schema, schemaWriteOnly);
        Map<JsonNode, List> content = contentAlternatives.stream().collect(CollectionUtils.toOrderedMap(json -> json, json -> ResponseAnalyzer.contentWriteOnly(json, schemaWriteOnly))).entrySet().stream().collect(CollectionUtils.toOrderedMap(e -> ResponseAnalyzer.contentWithoutWriteOnly((JsonNode)e.getKey(), (List)e.getValue()), e -> (List)e.getValue()));
        SchemaValidator schemaValidator = new SchemaValidator(null, schemaWithoutWriteOnly);
        Map<JsonNode, List> contentErrors = content.entrySet().stream().collect(CollectionUtils.toOrderedMap(e -> (JsonNode)e.getKey(), e -> {
            ValidationData validation = new ValidationData();
            schemaValidator.validate((JsonNode)e.getKey(), validation);
            return ResponseAnalyzer.validationErrors((ValidationData<Void>)validation);
        }));
        List contentWriteOnly = contentErrors.keySet().stream().filter(json -> ((List)contentErrors.get(json)).isEmpty()).collect(Collectors.toList());
        Optional<JsonNode> contentValid = contentWriteOnly.stream().filter(json -> ((List)content.get(json)).isEmpty()).findFirst();
        List list = contentInvalid = contentValid.isPresent() ? Collections.emptyList() : contentErrors.keySet().stream().sorted((json1, json2) -> Integer.compare(((List)contentErrors.get(json1)).size(), ((List)contentErrors.get(json2)).size())).collect(Collectors.toList());
        JsonNode withErrors = contentInvalid.isEmpty() ? null : (!contentWriteOnly.isEmpty() ? (JsonNode)contentWriteOnly.get(0) : contentInvalid.stream().filter(json -> ((List)contentErrors.get(json)).stream().noneMatch(error -> "#type".equals(error.getLocation()))).findFirst().orElse((JsonNode)contentInvalid.get(0)));
        return Optional.ofNullable(withErrors).map(json -> Stream.concat(((List)contentErrors.get(json)).stream(), ResponseAnalyzer.writeOnlyErrors((List)content.get(json)).stream()).collect(Collectors.toList()));
    }

    private static List<JsonPointer> matchesAt(JsonNode content, JsonPointer schemaLocation) {
        return ResponseAnalyzer.matchesAt(content, JsonUtils.pathOf(schemaLocation));
    }

    private static List<JsonPointer> matchesAt(JsonNode content, List<String> schemaPath) {
        int start;
        for (start = 0; start < schemaPath.size() - 1 && ("allOf".equals(schemaPath.get(start)) || "anyOf".equals(schemaPath.get(start)) || "oneOf".equals(schemaPath.get(start))) && JsonUtils.isInteger(schemaPath.get(start + 1)); start += 2) {
        }
        List<String> path = schemaPath.subList(start, schemaPath.size());
        return path.isEmpty() ? Collections.emptyList() : (path.get(0).equals("items") ? ResponseAnalyzer.matchesItemsAt(content, path) : (path.get(0).equals("additionalProperties") ? ResponseAnalyzer.matchesAdditionalAt(content, path) : ResponseAnalyzer.matchesPropertyAt(content, path)));
    }

    private static List<JsonPointer> matchesPropertyAt(JsonNode content, List<String> schemaPath) {
        JsonPointer propertyLocation = JsonUtils.pointer(schemaPath.get(1));
        JsonNode propertyValue = content.at(propertyLocation);
        List<String> pathFrom = schemaPath.subList(2, schemaPath.size());
        return propertyValue.isMissingNode() ? Collections.emptyList() : (pathFrom.isEmpty() ? Collections.singletonList(propertyLocation) : ResponseAnalyzer.matchesAt(propertyValue, pathFrom).stream().map(location -> propertyLocation.append(location)).collect(Collectors.toList()));
    }

    private static List<JsonPointer> matchesItemsAt(JsonNode content, List<String> schemaPath) {
        List<String> pathFrom = schemaPath.subList(1, schemaPath.size());
        return JsonUtils.asArray(content).map(array -> IntStream.range(0, array.size()).mapToObj(i -> ResponseAnalyzer.matchesAt(array.get(i), pathFrom).stream().map(location -> JsonUtils.pointer(String.valueOf(i)).append(location)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private static List<JsonPointer> matchesAdditionalAt(JsonNode content, List<String> schemaPath) {
        List<String> pathFrom = schemaPath.subList(1, schemaPath.size());
        return JsonUtils.asObject(content).map(object -> CollectionUtils.toStream(object.fieldNames()).map(property -> ResponseAnalyzer.matchesAt(object.get(property), pathFrom).stream().map(location -> JsonUtils.pointer(property).append(location)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private static List<SchemaValidationError> validationErrors(ValidationData<Void> validation) {
        return validation.results().items(ValidationSeverity.ERROR).stream().map(item -> {
            boolean moreSchemaKeys;
            StringBuilder schemaKeys = new StringBuilder();
            String crumbs = item.schemaCrumbs();
            int keyEnd = crumbs.lastIndexOf(62);
            boolean bl = moreSchemaKeys = keyEnd >= 0;
            while (moreSchemaKeys) {
                int keyStart = crumbs.lastIndexOf(60, keyEnd);
                boolean bl2 = moreSchemaKeys = keyStart >= 0;
                if (moreSchemaKeys) {
                    schemaKeys.insert(0, crumbs.substring(keyStart + 1, keyEnd));
                    keyEnd = keyStart - 2;
                }
                if (!(moreSchemaKeys = moreSchemaKeys && keyEnd > 0 && crumbs.substring(keyEnd, keyStart).equals(">."))) continue;
                schemaKeys.insert(0, "/");
            }
            return new SchemaValidationError(item.dataCrumbs(), schemaKeys.toString(), item.message());
        }).collect(Collectors.toList());
    }

    private static List<SchemaValidationError> writeOnlyErrors(List<JsonPointer> contentWriteOnly) {
        return contentWriteOnly.stream().map(location -> location.toString().substring(1)).map(dataLocation -> new SchemaValidationError((String)dataLocation, "writeOnly", "'writeOnly' property not allowed in response")).collect(Collectors.toList());
    }
}

