/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.test;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.cornutum.tcases.openapi.test.AbstractDecoder;
import org.cornutum.tcases.openapi.test.CollectionUtils;
import org.cornutum.tcases.openapi.test.ContentDef;
import org.cornutum.tcases.openapi.test.EncodingDef;
import org.cornutum.tcases.openapi.test.JsonUtils;
import org.cornutum.tcases.openapi.test.SimpleDecoder;
import org.cornutum.tcases.openapi.test.ToString;

public class FormUrlDecoder
extends AbstractDecoder {
    private final ContentDef contentDef_;

    public FormUrlDecoder(ContentDef contentDef) {
        super(contentDef.getValueEncoding());
        this.contentDef_ = contentDef;
    }

    @Override
    public List<JsonNode> decodeArray(String content) {
        return Collections.emptyList();
    }

    @Override
    public Optional<JsonNode> decodeNumber(String content) {
        return Optional.empty();
    }

    @Override
    public Optional<JsonNode> decodeBoolean(String content) {
        return Optional.empty();
    }

    @Override
    public Optional<JsonNode> decodeString(String content) {
        return Optional.empty();
    }

    @Override
    public List<JsonNode> decodeObject(String content) {
        return Optional.ofNullable(content).map(text -> text.isEmpty() ? new String[]{} : text.split("&", -1)).map(pairs -> {
            List mappings = Arrays.stream(pairs).map(pair -> pair.split("=", -1)).collect(Collectors.toList());
            mappings.stream().filter(mapping -> ((String[])mapping).length != 2).findFirst().ifPresent(mapping -> {
                throw new IllegalStateException(String.format("'%s' is not a valid key/value pair", Arrays.stream(mapping).collect(Collectors.joining("="))));
            });
            List<Map.Entry<Key, String>> bindings = mappings.stream().map(mapping -> CollectionUtils.mapping(Key.of(this.getContentDef(), this.decodeUrl(mapping[0])), this.decodeUrl(mapping[1]))).collect(Collectors.toList());
            return this.decodeObject(bindings);
        }).orElse(Collections.emptyList());
    }

    private List<JsonNode> decodeObject(List<Map.Entry<Key, String>> bindings) {
        List<Object> decoded;
        if (bindings.isEmpty()) {
            decoded = Collections.singletonList(JsonUtils.createObjectNode());
        } else {
            Key key = bindings.get(0).getKey();
            List<Map.Entry<Key, String>> bindingsForProperty = bindings.subList(0, IntStream.range(1, bindings.size()).filter(i -> !((Key)((Map.Entry)bindings.get(i)).getKey()).equalsFormProperty(key)).findFirst().orElse(bindings.size()));
            String formProperty = key.getFormProperty();
            decoded = this.decodeProperty(formProperty, bindingsForProperty).stream().map(propertyValue -> JsonUtils.newObject(formProperty, propertyValue)).flatMap(firstProperty -> this.decodeObject(bindings.subList(bindingsForProperty.size(), bindings.size())).stream().map(JsonUtils::expectObject).map(otherProperties -> JsonUtils.appendObject(firstProperty, otherProperties))).collect(Collectors.toList());
        }
        return decoded;
    }

    private List<JsonNode> decodeProperty(String formProperty, List<Map.Entry<Key, String>> bindings) {
        EncodingDef encoding = this.getPropertyEncoding(formProperty);
        return encoding.isExploded() == false ? Optional.of(bindings).filter(singleton -> singleton.size() == 1).map(singleton -> (Map.Entry)singleton.get(0)).map(binding -> this.forFormProperty((Map.Entry<Key, String>)binding).map(property -> this.decodeValue(encoding.getStyle(), (String)property.getValue())).orElseThrow(() -> new IllegalStateException(String.format("Unexpected value for %s", binding.getKey())))).orElseThrow(() -> new IllegalStateException(String.format("Expected explode=false for property='%s' but found %s bindings", formProperty, bindings.size()))) : ("deepObject".equals(encoding.getStyle()) ? this.decodeExplodedObject(Optional.of(bindings).filter(deepBindings -> this.isExplodedObject("deepObject", (List<Map.Entry<Key, String>>)deepBindings)).orElseThrow(() -> new IllegalStateException(String.format("Expected style=deepObject for property='%s' not found", formProperty)))) : this.decodeExploded(encoding.getStyle(), bindings));
    }

    private List<JsonNode> decodeExplodedObject(List<Map.Entry<Key, String>> bindings) {
        List<Object> decoded;
        if (bindings.isEmpty()) {
            decoded = Collections.singletonList(JsonUtils.createObjectNode());
        } else {
            Key key = bindings.get(0).getKey();
            String valueProperty = key.getValueProperty();
            String valuePropertyContent = bindings.get(0).getValue();
            decoded = this.decodeValue("simple", valuePropertyContent).stream().map(json -> JsonUtils.newObject(valueProperty, json)).flatMap(firstProperty -> this.decodeExplodedObject(bindings.subList(1, bindings.size())).stream().map(json -> JsonUtils.expectObject(json)).map(otherProperties -> JsonUtils.appendObject(firstProperty, otherProperties))).collect(Collectors.toList());
        }
        return decoded;
    }

    private Optional<Map.Entry<Key, String>> forFormProperty(Map.Entry<Key, String> binding) {
        return Optional.of(binding).filter(b -> ((Key)b.getKey()).isFormProperty());
    }

    private boolean isExplodedObject(String style, List<Map.Entry<Key, String>> bindings) {
        Map<String, List<Map.Entry<Key, String>>> explodedTypes = this.byExplodedType(bindings);
        boolean object = Optional.of(explodedTypes).filter(types -> types.size() == 1).map(types -> types.containsKey("object")).orElseThrow(() -> new IllegalStateException(bindings.isEmpty() ? "No exploded property bindings found" : String.format("Inconsistent bindings for style=%s: found bindings for %s and %s", style, ((Map.Entry)((List)explodedTypes.get("array")).get(0)).getKey(), ((Map.Entry)((List)explodedTypes.get("object")).get(0)).getKey())));
        if (object) {
            boolean expectDeep = "deepObject".equals(style);
            bindings.stream().filter(binding -> expectDeep != ((Key)binding.getKey()).isDeepObjectProperty()).findFirst().map(Map.Entry::getKey).ifPresent(unexpected -> {
                throw new IllegalStateException(String.format("Expected style=%s for property=%s but found value for %s", style, unexpected.getFormProperty(), unexpected));
            });
        }
        return object;
    }

    private Map<String, List<Map.Entry<Key, String>>> byExplodedType(List<Map.Entry<Key, String>> bindings) {
        return bindings.stream().collect(Collectors.groupingBy(binding -> ((Key)binding.getKey()).isFormProperty() ? "array" : "object"));
    }

    private List<JsonNode> decodeExploded(String style, List<Map.Entry<Key, String>> bindings) {
        return bindings.isEmpty() ? Collections.emptyList() : (this.isExplodedObject(style, bindings) ? this.decodeExplodedObject(bindings) : (bindings.size() == 1 ? this.decodeValue(style, bindings.get(0).getValue()) : this.decodeExplodedArray(bindings)));
    }

    private List<JsonNode> decodeExplodedArray(List<Map.Entry<Key, String>> bindings) {
        List<Object> decoded;
        if (bindings.isEmpty()) {
            decoded = Collections.singletonList(JsonUtils.createArrayNode());
        } else {
            String element = bindings.get(0).getValue();
            List<JsonNode> decodedRest = this.decodeExplodedArray(bindings.subList(1, bindings.size()));
            decoded = this.decodeValue("simple", element).stream().map(json -> JsonUtils.newArray(json)).flatMap(firstElement -> decodedRest.stream().map(json -> JsonUtils.expectArray(json)).map(otherElements -> JsonUtils.appendArray(firstElement, otherElements))).collect(Collectors.toList());
        }
        return decoded;
    }

    private List<JsonNode> decodeValue(String style, String content) {
        return this.getValueDecoder(EncodingDef.forSimpleValue(style, false)).decode(content);
    }

    public Map<String, EncodingDef> getPropertyEncodings() {
        return this.getContentDef().getPropertyEncodings();
    }

    public EncodingDef getPropertyEncoding(String property) {
        return Optional.ofNullable(this.getPropertyEncodings().get(property)).orElse(EncodingDef.forUrlEncodedForm());
    }

    private ContentDef getContentDef() {
        return this.contentDef_;
    }

    private SimpleDecoder getValueDecoder(EncodingDef encoding) {
        return new SimpleDecoder(encoding);
    }

    private static class Key {
        private final String formProperty_;
        private final String valueProperty_;
        private final boolean deep_;
        private static final Pattern DEEP_PROPERTY = Pattern.compile("([^\\[]*)\\[([^\\]]*)\\]");

        public static Key of(ContentDef contentDef, String name) {
            return Key.deepKeyOf(name).orElseGet(() -> Key.explodedKeyOf(contentDef, name).orElseGet(() -> new Key(name)));
        }

        private static Optional<Key> deepKeyOf(String name) {
            return Optional.of(DEEP_PROPERTY.matcher(name)).filter(matcher -> matcher.matches()).map(matcher -> new Key(matcher.group(1), matcher.group(2), true));
        }

        private static Optional<Key> explodedKeyOf(ContentDef contentDef, String name) {
            return Optional.ofNullable(contentDef.getSchema()).filter(form -> !form.has(name)).flatMap(form -> Key.schemaProperties(form).stream().filter(P -> Key.schemaProperties(JsonUtils.expectObject((JsonNode)P.getValue())).stream().map(Map.Entry::getKey).anyMatch(Q -> Q.equals(name))).findFirst().map(P -> new Key((String)P.getKey(), name, false)));
        }

        private static List<Map.Entry<String, JsonNode>> schemaProperties(ObjectNode schema) {
            return Optional.ofNullable(schema).flatMap(object -> JsonUtils.asObject(object.get("properties"))).map(properties -> CollectionUtils.toStream(properties.fields()).collect(Collectors.toList())).orElse(Collections.emptyList());
        }

        private Key(String formProperty, String valueProperty, boolean deep) {
            this.formProperty_ = formProperty;
            this.valueProperty_ = valueProperty;
            this.deep_ = deep;
        }

        private Key(String formProperty) {
            this(formProperty, null, false);
        }

        public String getFormProperty() {
            return this.formProperty_;
        }

        public String getValueProperty() {
            return this.valueProperty_;
        }

        public boolean isFormProperty() {
            return this.getValueProperty() == null;
        }

        public boolean isExplodedObjectProperty() {
            return !this.isFormProperty() && !this.isDeepObjectProperty();
        }

        public boolean isDeepObjectProperty() {
            return this.deep_;
        }

        public int hashCode() {
            return this.getClass().hashCode() ^ Objects.hashCode(this.getFormProperty()) ^ Objects.hashCode(this.getValueProperty()) ^ Boolean.hashCode(this.isDeepObjectProperty());
        }

        public boolean equalsFormProperty(Key other) {
            return Objects.equals(this.getFormProperty(), other.getFormProperty());
        }

        public boolean equals(Object object) {
            Key other = object != null && object.getClass().equals(this.getClass()) ? (Key)object : null;
            return other != null && this.equalsFormProperty(other) && Objects.equals(this.getValueProperty(), other.getValueProperty()) && this.isDeepObjectProperty() == other.isDeepObjectProperty();
        }

        public String toString() {
            String name = this.isDeepObjectProperty() ? "DeepObject" : (this.isExplodedObjectProperty() ? "ExplodedObject" : "Form");
            return ToString.builder(name).add(this.getFormProperty()).addIf(Optional.ofNullable(this.getValueProperty())).toString();
        }
    }
}

