/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.test;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import java.util.Optional;
import org.cornutum.tcases.openapi.test.EncodingDef;
import org.cornutum.tcases.openapi.test.ToString;

public class ContentDef {
    private final String contentType_;
    private final ObjectNode schema_;
    private final EncodingDef valueEncoding_;
    private final Map<String, EncodingDef> propertyEncodings_;

    public ContentDef(String contentType, ObjectNode schema, EncodingDef valueEncoding, Map<String, EncodingDef> propertyEncodings) {
        this.contentType_ = contentType;
        this.schema_ = schema;
        this.valueEncoding_ = Optional.ofNullable(valueEncoding).orElse(EncodingDef.forSimpleValue(false));
        this.propertyEncodings_ = propertyEncodings;
    }

    public String getContentType() {
        return this.contentType_;
    }

    public ObjectNode getSchema() {
        return this.schema_;
    }

    public boolean isExploded() {
        return this.getValueEncoding().isExploded();
    }

    public EncodingDef getValueEncoding() {
        return this.valueEncoding_;
    }

    public Map<String, EncodingDef> getPropertyEncodings() {
        return this.propertyEncodings_;
    }

    public String toString() {
        return ToString.builder(this.getClass()).add("contentType", this.getContentType()).addIf("dataType", Optional.ofNullable(this.getSchema()).flatMap(s -> Optional.ofNullable(s.get("type").asText()))).add("valueEncoding=", this.getValueEncoding()).toString();
    }
}

