/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.util;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public final class ObjectUtils {
    private ObjectUtils() {
    }

    public static Object toObject(String value) {
        return ObjectUtils.toObject(value, ObjectUtils::toBoolean, ObjectUtils::toNumber, ObjectUtils::toExternalString);
    }

    public static Object toExternalObject(Object value) {
        return ObjectUtils.toObject(String.valueOf(value));
    }

    @SafeVarargs
    private static <T> Object toObject(T value, Function<T, Object> ... converters) {
        return Stream.of(converters).map(converter -> converter.apply(value)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static Object toBoolean(String value) {
        return "true".equalsIgnoreCase(value) ? Boolean.TRUE : ("false".equalsIgnoreCase(value) ? Boolean.FALSE : null);
    }

    private static Object toNumber(String value) {
        Object number;
        try {
            number = ObjectUtils.toExternalNumber(new BigDecimal(value));
        }
        catch (Exception e) {
            number = null;
        }
        return number;
    }

    private static Object toExternalString(String value) {
        return "null".equals(value) ? null : value;
    }

    private static Object toInt(BigDecimal value) {
        Integer number;
        try {
            number = value.scale() == 0 ? Integer.valueOf(value.intValueExact()) : null;
        }
        catch (Exception e) {
            number = null;
        }
        return number;
    }

    private static Object toLong(BigDecimal value) {
        Long number;
        try {
            number = value.scale() == 0 ? Long.valueOf(value.longValueExact()) : null;
        }
        catch (Exception e) {
            number = null;
        }
        return number;
    }

    private static Object toExternalNumber(BigDecimal number) {
        return Optional.ofNullable(ObjectUtils.toObject(number, ObjectUtils::toInt, ObjectUtils::toLong)).orElse(number);
    }
}

