/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class MapBuilder<K, V> {
    private Map<K, V> map_;

    public MapBuilder() {
        this(HashMap.class);
    }

    public <T extends Map<K, V>> MapBuilder(Class<T> type) {
        try {
            this.map_ = (Map)type.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't create instance of type=" + type);
        }
    }

    public static <K, V> MapBuilder<K, V> of(K key, V value) {
        return new MapBuilder<K, V>().put(key, value);
    }

    public MapBuilder<K, V> put(K key, V value) {
        this.map_.put(key, value);
        return this;
    }

    public MapBuilder<K, V> putIf(K key, Optional<V> value) {
        value.ifPresent(v -> this.map_.put(key, v));
        return this;
    }

    public Map<K, V> build() {
        return this.map_;
    }
}

