/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ListBuilder<T> {
    private List<T> list_;

    protected ListBuilder() {
        this(null);
    }

    protected ListBuilder(List<T> list) {
        this.list_ = list == null ? new ArrayList() : list;
    }

    public static <T> ListBuilder<T> to() {
        return ListBuilder.to(null);
    }

    public static <T> ListBuilder<T> to(List<T> list) {
        return new ListBuilder<T>(list);
    }

    public ListBuilder<T> add(T element) {
        this.list_.add(element);
        return this;
    }

    public ListBuilder<T> add(Optional<T> element) {
        element.ifPresent(e -> this.list_.add(e));
        return this;
    }

    public ListBuilder<T> addAll(Iterable<T> elements) {
        for (T element : elements) {
            this.list_.add(element);
        }
        return this;
    }

    public int size() {
        return this.list_.size();
    }

    public List<T> build() {
        return this.list_;
    }
}

