/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> Stream<T> toStream(Iterator<T> iterator) {
        return Optional.ofNullable(iterator).map(i -> {
            Iterable iterable = () -> i;
            return CollectionUtils.toStream(iterable);
        }).orElse(null);
    }

    public static <T> Stream<T> toStream(Iterable<T> iterable) {
        return Optional.ofNullable(iterable).map(i -> StreamSupport.stream(i.spliterator(), false)).orElse(null);
    }

    public static <T> List<T> iterableOf(Optional<T> value) {
        return value.map(xva$0 -> Arrays.asList(xva$0)).orElse(Collections.emptyList());
    }

    public static <T> Stream<T> streamOf(Optional<T> value) {
        return value.map(Stream::of).orElse(Stream.empty());
    }

    public static <T, C extends Collection<T>> Stream<T> membersOf(C collection) {
        return collection == null ? Stream.empty() : collection.stream();
    }

    public static <K, V, M extends Map<K, V>> Stream<Map.Entry<K, V>> entriesOf(M map) {
        return map == null ? Stream.empty() : map.entrySet().stream();
    }

    public static String toCsv(Stream<?> values) {
        return values.map(value -> Optional.ofNullable(value).map(v -> String.format("'%s'", v.toString().replace("\\", "\\\\").replace("'", "\\'"))).orElse("null")).collect(Collectors.joining(","));
    }

    public static Stream<String> fromCsv(String csv) {
        Stream.Builder<String> values = Stream.builder();
        if (csv != null) {
            int length = csv.length();
            for (int i = 0; i < length; ++i) {
                if (csv.startsWith("null", i)) {
                    values.add(null);
                    i += "null".length();
                    continue;
                }
                if (csv.charAt(i) == '\'') {
                    StringBuilder value = new StringBuilder();
                    ++i;
                    while (i < length && csv.charAt(i) != '\'') {
                        if (csv.charAt(i) == '\\') {
                            ++i;
                        }
                        if (i < length) {
                            value.append(csv.charAt(i));
                        }
                        ++i;
                    }
                    values.add(value.toString());
                    ++i;
                    continue;
                }
                throw new IllegalArgumentException(String.format("Invalid CSV: value at index=%s is neither null nor a quoted string", i));
            }
        }
        return values.build();
    }

    public static <T> Collector<T, ?, Set<T>> toOrderedSet() {
        return Collectors.toCollection(LinkedHashSet::new);
    }

    public static <T> Set<T> asOrderedSet(Iterable<T> elements) {
        return Optional.ofNullable(elements).map(CollectionUtils::toStream).orElse(Stream.empty()).collect(CollectionUtils.toOrderedSet());
    }

    @SafeVarargs
    public static <T> Set<T> asOrderedSet(T ... elements) {
        return CollectionUtils.asOrderedSet(Arrays.asList(elements));
    }

    public static <T> List<T> restOf(List<T> members, int excluded) {
        return IntStream.range(0, members.size()).filter(i -> i != excluded).mapToObj(i -> members.get(i)).collect(Collectors.toList());
    }
}

