/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections4.Predicate;
import org.cornutum.tcases.util.ListBuilder;

public class CartesianProduct<T>
implements Iterator<List<T>> {
    private List<T> addedTo_;
    private Iterator<T> firstSetIterator_;
    private T firstSetNext_;
    private List<? extends Set<T>> otherSets_;
    private Iterator<? extends List<T>> otherSetsProduct_;
    private List<T> next_;
    private Predicate<List<T>> filter_;

    public CartesianProduct(List<? extends Set<T>> sets) {
        this(sets, null);
    }

    public CartesianProduct(List<? extends Set<T>> sets, Predicate<List<T>> filter) {
        this(Collections.emptyList(), sets, filter);
    }

    private CartesianProduct(List<T> addedTo, List<? extends Set<T>> sets, Predicate<List<T>> filter) {
        this.addedTo_ = addedTo;
        this.filter_ = filter;
        int setCount = sets.size();
        Set firstSet = setCount == 0 ? Collections.emptySet() : sets.get(0);
        this.firstSetIterator_ = firstSet.iterator();
        this.otherSets_ = setCount < 2 ? Collections.emptyList() : sets.subList(1, setCount);
    }

    @Override
    public boolean hasNext() {
        return this.getNext() != null;
    }

    @Override
    public List<T> next() {
        List<T> next = this.getNext();
        if (next == null) {
            throw new NoSuchElementException();
        }
        this.next_ = null;
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private List<T> getNext() {
        if (this.next_ == null) {
            if (this.firstSetNext_ != null && this.otherSetsProduct_.hasNext()) {
                this.next_ = ListBuilder.to().add(this.firstSetNext_).addAll((Iterable)this.otherSetsProduct_.next()).build();
            } else if (this.firstSetIterator_.hasNext()) {
                List<T> nextAddedTo = null;
                while (this.firstSetIterator_.hasNext() && (nextAddedTo = this.getNextAddedTo(this.firstSetNext_ = this.firstSetIterator_.next())) == null) {
                }
                if (nextAddedTo != null) {
                    this.otherSetsProduct_ = this.otherSets_.isEmpty() ? Arrays.asList(Collections.emptyList()).iterator() : new CartesianProduct<T>(nextAddedTo, this.otherSets_, this.filter_);
                    this.next_ = this.getNext();
                }
            }
        }
        return this.next_;
    }

    private List<T> getNextAddedTo(T firstSetNext) {
        ListBuilder builder;
        return this.filter_ == null ? this.addedTo_ : (this.filter_.evaluate((builder = ListBuilder.to().addAll(this.addedTo_).add(firstSetNext)).build()) ? builder.build() : null);
    }
}

