/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.IteratorUtils;
import org.cornutum.tcases.VarBindingDef;
import org.cornutum.tcases.VarDef;
import org.cornutum.tcases.generator.TestCaseDef;
import org.cornutum.tcases.generator.Tuple;
import org.cornutum.tcases.util.ToString;

public class VarTupleSet {
    private List<Tuple> unused_ = new ArrayList<Tuple>();
    private List<Tuple> used_;
    private boolean usedChanged_;
    private static final Comparator<Tuple> tupleSizeDescending_ = new Comparator<Tuple>(){

        @Override
        public int compare(Tuple tuple1, Tuple tuple2) {
            return tuple2.size() - tuple1.size();
        }
    };

    public VarTupleSet(List<Tuple> tuples) {
        if (tuples != null) {
            this.unused_.addAll(tuples);
        }
        this.used_ = new ArrayList<Tuple>();
    }

    public Iterator<Tuple> getUnused() {
        return this.unused_.iterator();
    }

    public Iterator<Tuple> getUnused(VarDef var) {
        return this.getBinds(this.unused_.iterator(), var);
    }

    public double getUnusedScore(VarBindingDef binding) {
        return this.unused_.isEmpty() ? 0.0 : (double)IterableUtils.countMatches(this.unused_, tuple -> tuple.contains(binding)) / (double)this.unused_.size();
    }

    public Iterator<Tuple> getUsed() {
        if (this.usedChanged_) {
            Collections.sort(this.used_, tupleSizeDescending_);
            this.usedChanged_ = false;
        }
        return this.used_.iterator();
    }

    public Iterator<Tuple> getUsed(VarDef var) {
        return this.getUsed(var, false);
    }

    public Iterator<Tuple> getUsedOnce(VarDef var) {
        return this.getUsed(var, true);
    }

    public Iterator<Tuple> getUsed(VarDef var, boolean onceOnly) {
        return this.getBinds(IteratorUtils.filteredIterator(this.getUsed(), tuple -> tuple.isOnce() == onceOnly), var);
    }

    public double getUsedScore(VarBindingDef binding) {
        return this.getUsedScore(binding, false);
    }

    public double getUsedOnceScore(VarBindingDef binding) {
        return this.getUsedScore(binding, true);
    }

    private double getUsedScore(VarBindingDef binding, boolean onceOnly) {
        Tuple nextTuple;
        int index;
        int usedCount = this.used_.size();
        for (index = usedCount - 1; index >= 0 && (nextTuple = this.used_.get(index)) != null && (onceOnly && !nextTuple.isOnce() || !nextTuple.contains(binding)); --index) {
        }
        return index < 0 ? 0.0 : (double)(index + 1) / (double)(usedCount + 1);
    }

    private Iterator<Tuple> getBinds(Iterator<Tuple> tuples, VarDef var) {
        return IteratorUtils.filteredIterator(tuples, tuple -> tuple.getBinding(var) != null);
    }

    public void used(TestCaseDef testCase) {
        List usedTuples = IteratorUtils.toList((Iterator)IteratorUtils.filteredIterator((Iterator)IteratorUtils.chainedIterator(this.unused_.iterator(), this.used_.iterator()), tuple -> testCase.usesTuple((Tuple)tuple)));
        for (Tuple tuple2 : usedTuples) {
            this.used(tuple2);
        }
    }

    public void used(Tuple tuple) {
        int i = this.unused_.indexOf(tuple);
        if (i >= 0) {
            this.unused_.remove(i);
            this.addUsed(tuple);
            if (tuple.size() > 1) {
                Iterator<VarBindingDef> bindings = tuple.getBindings();
                while (bindings.hasNext()) {
                    Tuple tuple1 = new Tuple(bindings.next());
                    tuple1.setOnce(tuple.isOnce());
                    i = this.used_.indexOf(tuple1);
                    if (i >= 0) {
                        this.used_.remove(i);
                    }
                    this.addUsed(tuple1);
                }
            }
        } else {
            i = this.used_.indexOf(tuple);
            if (i >= 0) {
                this.addUsed(this.used_.remove(i));
            }
        }
    }

    private void addUsed(Tuple tuple) {
        this.used_.add(tuple);
        this.usedChanged_ = true;
    }

    public void remove(Tuple tuple) {
        int i = this.unused_.indexOf(tuple);
        if (i >= 0) {
            this.unused_.remove(tuple);
        }
    }

    public Tuple getNextUnused() {
        Iterator<Tuple> unused = this.getUnused();
        return unused.hasNext() ? unused.next() : null;
    }

    public String toString() {
        return ToString.getBuilder(this).append("used", this.used_.size()).append("unused", this.unused_.size()).toString();
    }
}

