/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.generator;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.cornutum.tcases.DefUtils;
import org.cornutum.tcases.FunctionInputDef;
import org.cornutum.tcases.IVarDef;

public class VarNamePattern {
    private String[] varNamePath_;
    private int minDepth_;
    private boolean wildcard_;
    private static final String ALL_DESCENDANTS = "**";
    private static final String ALL_CHILDREN = "*";

    public VarNamePattern(String pattern) {
        this.varNamePath_ = StringUtils.isBlank((CharSequence)pattern) ? null : DefUtils.toPath(pattern);
        int patternLength = this.varNamePath_ == null ? 0 : this.varNamePath_.length;
        this.minDepth_ = 0;
        this.wildcard_ = false;
        while (this.minDepth_ < patternLength && !(this.wildcard_ = ALL_DESCENDANTS.equals(this.varNamePath_[this.minDepth_]) || ALL_CHILDREN.equals(this.varNamePath_[this.minDepth_]))) {
            ++this.minDepth_;
        }
    }

    public boolean matches(String varName) {
        return this.matches(new VarNamePattern(varName));
    }

    public boolean matches(VarNamePattern varName) {
        boolean matched;
        boolean bl = varName != null && varName.varNamePath_ == null == (this.varNamePath_ == null) && !varName.wildcard_ && varName.minDepth_ >= this.minDepth_ ? true : (matched = false);
        if (matched && this.varNamePath_ != null) {
            int i;
            for (i = 0; i < this.minDepth_ && (matched = varName.varNamePath_[i].equals(this.varNamePath_[i])); ++i) {
            }
            if (matched) {
                String wildcardType;
                int membersLeft = varName.minDepth_ - this.minDepth_;
                String string = wildcardType = !this.wildcard_ ? null : this.varNamePath_[i];
                matched = wildcardType == null ? membersLeft == 0 : membersLeft == 1 && wildcardType.equals(ALL_CHILDREN) || wildcardType.equals(ALL_DESCENDANTS);
            }
        }
        return matched;
    }

    public boolean isValid() {
        boolean valid;
        boolean bl = valid = this.varNamePath_ != null;
        if (valid) {
            int i;
            for (i = 0; i < this.varNamePath_.length && DefUtils.isIdentifier(this.varNamePath_[i]); ++i) {
            }
            int membersLeft = this.varNamePath_.length - i;
            valid = membersLeft == 0 || membersLeft == 1 && (this.varNamePath_[i].equals(ALL_DESCENDANTS) || this.varNamePath_[i].equals(ALL_CHILDREN));
        }
        return valid;
    }

    public boolean isApplicable(FunctionInputDef inputDef) {
        return this.isApplicable(inputDef.getVarDefs());
    }

    private boolean isApplicable(Iterator<IVarDef> varDefs) {
        boolean applicable = false;
        while (varDefs.hasNext() && !(applicable = this.isApplicable(varDefs.next()))) {
        }
        return applicable;
    }

    private boolean isApplicable(IVarDef var) {
        Iterator<IVarDef> members = var.getMembers();
        return members == null ? this.matches(var.getPathName()) : this.isApplicable(members);
    }

    public boolean equals(Object object) {
        return object != null && object.getClass().equals(this.getClass()) && Arrays.equals(this.varNamePath_, ((VarNamePattern)object).varNamePath_);
    }

    public int hashCode() {
        int code = this.getClass().hashCode();
        int pathSize = this.varNamePath_ == null ? 0 : this.varNamePath_.length;
        int i = 0;
        while (i < pathSize) {
            code ^= this.varNamePath_[i++].hashCode();
        }
        return code;
    }

    public String toString() {
        return StringUtils.join((Object[])this.varNamePath_, (char)'.');
    }
}

