/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.generator;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.cornutum.tcases.VarBindingDef;
import org.cornutum.tcases.VarDef;
import org.cornutum.tcases.VarValueDef;
import org.cornutum.tcases.generator.RandSeq;
import org.cornutum.tcases.generator.Tuple;
import org.cornutum.tcases.util.ToString;

public class TupleIterator
implements Iterator<Tuple> {
    private int tupleSize_;
    private List<VarDef> varDefs_;
    private RandSeq randSeq_;
    private int varStart_;
    private int varEnd_;
    private Iterator<VarValueDef> values_;
    private Tuple subTuple_;
    private TupleIterator subTuples_;
    private Tuple nextTuple_;

    public TupleIterator(int tupleSize, List<VarDef> varDefs) {
        this(tupleSize, varDefs, null);
    }

    public TupleIterator(int tupleSize, List<VarDef> varDefs, RandSeq randSeq) {
        this.setTupleSize(tupleSize);
        this.varDefs_ = varDefs;
        this.randSeq_ = randSeq;
        this.varStart_ = -1;
        this.varEnd_ = varDefs.size() - tupleSize + 1;
        if (tupleSize < 1 || this.varEnd_ <= 0) {
            throw new IllegalArgumentException("Can't create " + tupleSize + "-tuples for a list of size=" + varDefs.size());
        }
    }

    @Override
    public boolean hasNext() {
        return this.getNextCompatibleTuple() != null;
    }

    @Override
    public Tuple next() {
        Tuple nextTuple = this.getNextCompatibleTuple();
        if (nextTuple == null) {
            throw new NoSuchElementException();
        }
        this.nextTuple_ = null;
        return nextTuple;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void setTupleSize(int tupleSize) {
        this.tupleSize_ = tupleSize;
    }

    public int getTupleSize() {
        return this.tupleSize_;
    }

    private Tuple getNextCompatibleTuple() {
        Tuple nextTuple;
        while ((nextTuple = this.getNextTuple()) != null && !nextTuple.isCompatible()) {
            this.nextTuple_ = null;
        }
        return nextTuple;
    }

    private Tuple getNextTuple() {
        if (this.nextTuple_ == null) {
            int tupleSize = this.getTupleSize();
            if (this.values_ == null || !this.values_.hasNext()) {
                this.values_ = null;
                this.subTuple_ = null;
                if (this.subTuples_ == null || !this.subTuples_.hasNext()) {
                    this.subTuples_ = null;
                    ++this.varStart_;
                    if (tupleSize > 1) {
                        while (this.varStart_ < this.varEnd_ && !(this.subTuples_ = new TupleIterator(tupleSize - 1, this.varDefs_.subList(this.varStart_ + 1, this.varDefs_.size()), this.randSeq_)).hasNext()) {
                            ++this.varStart_;
                        }
                    }
                }
            }
            if (this.varStart_ < this.varEnd_) {
                VarDef startVarDef = this.varDefs_.get(this.varStart_);
                if (this.values_ == null) {
                    this.values_ = RandSeq.reorderIf(this.randSeq_, startVarDef.getValidValues());
                    if (!this.values_.hasNext()) {
                        throw new IllegalStateException("Can't complete tuples -- no valid values defined for var=" + startVarDef);
                    }
                    if (tupleSize > 1) {
                        this.subTuple_ = this.subTuples_.next();
                    }
                }
                this.nextTuple_ = new Tuple();
                this.nextTuple_.add(new VarBindingDef(startVarDef, this.values_.next()));
                if (this.subTuple_ != null) {
                    this.nextTuple_.addAll(this.subTuple_);
                }
            }
        }
        return this.nextTuple_;
    }

    public String toString() {
        return ToString.getBuilder(this).append("size", this.getTupleSize()).toString();
    }
}

