/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.generator;

import java.util.stream.Stream;
import org.cornutum.tcases.generator.TupleCombiner;
import org.cornutum.tcases.generator.TupleGenerator;

public class TupleGeneratorBuilder {
    TupleGenerator tupleGenerator_;

    public static TupleGeneratorBuilder with(TupleGenerator tupleGenerator) {
        return new TupleGeneratorBuilder(tupleGenerator);
    }

    public TupleGeneratorBuilder() {
        this.start();
    }

    public TupleGeneratorBuilder(TupleGenerator tupleGenerator) {
        this.start(tupleGenerator);
    }

    public TupleGenerator build() {
        return this.tupleGenerator_;
    }

    public TupleGeneratorBuilder start() {
        return this.start(null);
    }

    public TupleGeneratorBuilder start(TupleGenerator tupleGenerator) {
        this.tupleGenerator_ = tupleGenerator == null ? new TupleGenerator() : tupleGenerator;
        return this;
    }

    public TupleGeneratorBuilder tuples(int tupleSize) {
        this.tupleGenerator_.setDefaultTupleSize(tupleSize);
        return this;
    }

    public TupleGeneratorBuilder seed(Long seed) {
        this.tupleGenerator_.setRandomSeed(seed);
        return this;
    }

    public TupleGeneratorBuilder combiners(TupleCombiner ... combiners) {
        for (TupleCombiner combiner : combiners) {
            this.tupleGenerator_.addCombiner(combiner);
        }
        return this;
    }

    public TupleGeneratorBuilder combiners(Iterable<TupleCombiner> combiners) {
        for (TupleCombiner combiner : combiners) {
            this.tupleGenerator_.addCombiner(combiner);
        }
        return this;
    }

    public TupleGeneratorBuilder combiners(Stream<TupleCombiner> combiners) {
        combiners.forEach(combiner -> this.tupleGenerator_.addCombiner((TupleCombiner)combiner));
        return this;
    }
}

