/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.functors.NOPTransformer;
import org.cornutum.tcases.FunctionInputDef;
import org.cornutum.tcases.FunctionTestDef;
import org.cornutum.tcases.TestCase;
import org.cornutum.tcases.VarBinding;
import org.cornutum.tcases.VarBindingDef;
import org.cornutum.tcases.VarDef;
import org.cornutum.tcases.VarDefIterator;
import org.cornutum.tcases.VarNaDef;
import org.cornutum.tcases.VarValueDef;
import org.cornutum.tcases.generator.ITestCaseGenerator;
import org.cornutum.tcases.generator.RandSeq;
import org.cornutum.tcases.generator.TestCaseDef;
import org.cornutum.tcases.generator.Tuple;
import org.cornutum.tcases.generator.TupleCombiner;
import org.cornutum.tcases.generator.VarTupleSet;
import org.cornutum.tcases.util.CartesianProduct;
import org.cornutum.tcases.util.ToString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleGenerator
implements ITestCaseGenerator {
    private Long seed_;
    private int defaultTupleSize_;
    private List<TupleCombiner> combiners_;
    private MultiValuedMap<String, VarBindingDef> propertyProviders_;
    private static final Logger logger_ = LoggerFactory.getLogger(TupleGenerator.class);
    private static final Comparator<VarBindingDef> varBindingDefSorter_ = new Comparator<VarBindingDef>(){

        @Override
        public int compare(VarBindingDef binding1, VarBindingDef binding2) {
            String var2;
            String var1 = binding1.getVarDef().getPathName();
            int result = var1.compareTo(var2 = binding2.getVarDef().getPathName());
            if (result == 0) {
                String value1 = String.valueOf(binding1.getValueDef().getName());
                String value2 = String.valueOf(binding2.getValueDef().getName());
                result = value1.compareTo(value2);
            }
            return result;
        }
    };
    private static final Comparator<Set<VarBindingDef>> varBindingSetSorter_ = new Comparator<Set<VarBindingDef>>(){

        @Override
        public int compare(Set<VarBindingDef> bindingSet1, Set<VarBindingDef> bindingSet2) {
            int result = bindingSet1.size() - bindingSet2.size();
            if (result == 0) {
                Iterator<VarBindingDef> bindings1 = bindingSet1.iterator();
                Iterator<VarBindingDef> bindings2 = bindingSet2.iterator();
                while (bindings1.hasNext() && (result = varBindingDefSorter_.compare(bindings1.next(), bindings2.next())) == 0) {
                }
            }
            return result;
        }
    };
    private static final Comparator<TupleCombiner> byTupleSize_ = new Comparator<TupleCombiner>(){

        @Override
        public int compare(TupleCombiner combiner1, TupleCombiner combiner2) {
            return this.effectiveTupleSize(combiner2.getTupleSize()) - this.effectiveTupleSize(combiner1.getTupleSize());
        }

        private int effectiveTupleSize(int tupleSize) {
            return tupleSize < 1 ? Integer.MAX_VALUE : tupleSize;
        }
    };

    public TupleGenerator() {
        this(1);
    }

    public TupleGenerator(int tupleSize) {
        this.setDefaultTupleSize(tupleSize);
        this.setCombiners(null);
    }

    public void setDefaultTupleSize(int tupleSize) {
        this.defaultTupleSize_ = tupleSize;
    }

    public int getDefaultTupleSize() {
        return this.defaultTupleSize_;
    }

    public void setCombiners(List<TupleCombiner> combiners) {
        this.combiners_ = new ArrayList<TupleCombiner>();
        if (combiners != null) {
            this.combiners_.addAll(combiners);
        }
    }

    public List<TupleCombiner> getCombiners() {
        return this.combiners_;
    }

    public void addCombiner(TupleCombiner combiner) {
        this.combiners_.add(combiner);
    }

    @Override
    public void setRandomSeed(Long seed) {
        this.seed_ = seed;
    }

    public Long getRandomSeed() {
        return this.seed_;
    }

    @Override
    public FunctionTestDef getTests(FunctionInputDef inputDef, FunctionTestDef baseTests) {
        try {
            logger_.info("{}: Preparing constraint info", (Object)inputDef);
            this.createPropertyProviders(inputDef);
            logger_.info("{}: Generating test cases", (Object)inputDef);
            List<TestCaseDef> baseCases = this.getBaseCases(inputDef, baseTests);
            RandSeq randSeq = this.getRandomSeed() == null ? null : new RandSeq(this.getRandomSeed());
            VarTupleSet validTuples = this.getValidTupleSet(randSeq, inputDef);
            List<TestCaseDef> validCases = this.getBaseValidCases(inputDef, validTuples, baseCases);
            validCases.addAll(this.getValidCases(inputDef, validTuples));
            VarTupleSet failureTuples = this.getFailureTupleSet(randSeq, inputDef);
            List<TestCaseDef> failureCases = this.getBaseFailureCases(inputDef, validTuples, failureTuples, baseCases);
            failureCases.addAll(this.getFailureCases(inputDef, failureTuples, validTuples));
            FunctionTestDef testDef = new FunctionTestDef(inputDef.getName());
            ArrayList<TestCaseDef> testCaseDefs = new ArrayList<TestCaseDef>();
            testCaseDefs.addAll(validCases);
            testCaseDefs.addAll(failureCases);
            Collections.sort(testCaseDefs);
            int nextId = -1;
            for (TestCaseDef testCase : testCaseDefs) {
                Integer id = testCase.getId();
                nextId = id == null ? nextId + 1 : id;
                testDef.addTestCase(testCase.createTestCase(nextId));
            }
            logger_.info("{}: Completed {} test cases", (Object)inputDef, (Object)testCaseDefs.size());
            return testDef;
        }
        catch (Exception e) {
            logger_.error(String.valueOf(inputDef) + ": Can't create test cases", (Throwable)e);
            throw new RuntimeException(String.valueOf(inputDef) + ": Can't create test cases", e);
        }
    }

    private List<TestCaseDef> getBaseCases(FunctionInputDef inputDef, FunctionTestDef baseTests) {
        logger_.debug("{}: Creating base test cases", (Object)inputDef);
        ArrayList<TestCaseDef> testCases = new ArrayList<TestCaseDef>();
        if (baseTests != null) {
            Iterator<TestCase> baseCases = baseTests.getTestCases();
            while (baseCases.hasNext()) {
                TestCase baseTest = baseCases.next();
                TestCaseDef testCase = new TestCaseDef();
                testCase.setId(baseTest.getId());
                testCase.setName(baseTest.getName());
                logger_.debug("Adding base test={}", (Object)baseTest);
                Iterator<VarBinding> bindings = baseTest.getVarBindings();
                while (testCase != null && bindings.hasNext()) {
                    VarValueDef value;
                    VarBinding binding = bindings.next();
                    VarDef var = inputDef.findVarDefPath(binding.getVar());
                    VarValueDef varValueDef = value = var == null ? null : var.getValue(binding.getValue());
                    if (var == null) {
                        logger_.trace("Var={} undefined", (Object)binding.getVar());
                        continue;
                    }
                    if (value == null) {
                        logger_.trace("Value={} undefined", (Object)binding);
                        continue;
                    }
                    if (value.isValid() != binding.isValueValid()) {
                        logger_.debug("Can't add {}, {} changed to failure={}", new Object[]{baseTest, binding, !value.isValid()});
                        testCase = null;
                        continue;
                    }
                    testCase.addCompatible(new Tuple(new VarBindingDef(var, value)));
                }
                if (testCase == null || !testCase.getVars().hasNext()) continue;
                testCases.add(testCase);
            }
        }
        logger_.debug("{}: Completed {} base test cases", (Object)inputDef, (Object)testCases.size());
        return testCases;
    }

    private List<TestCaseDef> extendBaseCases(FunctionInputDef inputDef, VarTupleSet validTuples, Iterator<TestCaseDef> baseCases) {
        ArrayList<TestCaseDef> testCases = new ArrayList<TestCaseDef>();
        while (baseCases.hasNext()) {
            TestCaseDef testCase = baseCases.next();
            logger_.debug("Extending base test case={}", (Object)testCase);
            if (this.makeComplete(testCase, validTuples, this.getVarsRemaining(inputDef, testCase))) {
                logger_.debug("Completed test case={}", (Object)testCase);
                validTuples.used(testCase);
                testCases.add(testCase);
                continue;
            }
            logger_.debug("Can't complete test case={}", (Object)testCase);
        }
        return testCases;
    }

    private List<TestCaseDef> getBaseValidCases(FunctionInputDef inputDef, VarTupleSet validTuples, List<TestCaseDef> baseCases) {
        logger_.debug("{}: Extending valid base test cases", (Object)inputDef);
        Iterator validBaseCases = IteratorUtils.filteredIterator(baseCases.iterator(), testCase -> testCase.getInvalidVar() == null);
        List<TestCaseDef> testCases = this.extendBaseCases(inputDef, validTuples, validBaseCases);
        logger_.info("{}: Extended {} valid base test cases", (Object)inputDef, (Object)testCases.size());
        return testCases;
    }

    private List<TestCaseDef> getBaseFailureCases(FunctionInputDef inputDef, VarTupleSet validTuples, VarTupleSet failureTuples, List<TestCaseDef> baseCases) {
        logger_.debug("{}: Extending base failure test cases", (Object)inputDef);
        Iterator failureBaseCases = IteratorUtils.filteredIterator(baseCases.iterator(), testCase -> testCase.getInvalidVar() != null);
        List<TestCaseDef> testCases = this.extendBaseCases(inputDef, validTuples, failureBaseCases);
        for (TestCaseDef testCase2 : testCases) {
            VarDef failureVar = testCase2.getInvalidVar();
            failureTuples.used(new Tuple(new VarBindingDef(failureVar, testCase2.getValue(failureVar))));
        }
        logger_.info("{}: Extended {} base failure test cases", (Object)inputDef, (Object)testCases.size());
        return testCases;
    }

    private List<TestCaseDef> getValidCases(FunctionInputDef inputDef, VarTupleSet validTuples) {
        Tuple nextUnused;
        logger_.debug("{}: Creating valid test cases", (Object)inputDef);
        ArrayList<TestCaseDef> validCases = new ArrayList<TestCaseDef>();
        while ((nextUnused = validTuples.getNextUnused()) != null) {
            TestCaseDef validCase = this.createTestCase(nextUnused, inputDef, validTuples);
            if (validCase != null) {
                validTuples.used(validCase);
                validCases.add(validCase);
                continue;
            }
            validTuples.remove(nextUnused);
        }
        logger_.info("{}: Created {} valid test cases", (Object)inputDef, (Object)validCases.size());
        return validCases;
    }

    private TestCaseDef createTestCase(Tuple tuple, FunctionInputDef inputDef, VarTupleSet validTuples) {
        logger_.debug("Creating new test case for tuple={}", (Object)tuple);
        TestCaseDef newCase = new TestCaseDef();
        try {
            newCase.setName(tuple);
            newCase.addBindings(tuple);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't initialize new test case", e);
        }
        if (this.makeComplete(newCase, validTuples, this.getVarsRemaining(inputDef, newCase))) {
            logger_.debug("Completed test case={}", (Object)newCase);
        } else if (tuple.size() > 1) {
            logger_.warn("Can't create test case for tuple={}", (Object)tuple);
            newCase = null;
        } else {
            throw new RuntimeException("Can't create test case for tuple=" + tuple);
        }
        return newCase;
    }

    private boolean makeComplete(TestCaseDef testCase, VarTupleSet tuples, List<VarDef> vars) {
        boolean complete;
        if (testCase.isSatisfied()) {
            complete = this.completeSatisfied(testCase, tuples, vars);
        } else {
            int prevBindings = testCase.getBindingCount();
            Iterator<Tuple> satisfyingTuples = this.getSatisfyingTuples(testCase, tuples);
            complete = false;
            while (!(!satisfyingTuples.hasNext() || this.makeSatisfied(testCase, tuples, satisfyingTuples.next()) && (complete = this.completeSatisfied(testCase, tuples, vars)))) {
                testCase.revertBindings(prevBindings);
            }
        }
        return complete;
    }

    private boolean completeSatisfied(TestCaseDef testCase, VarTupleSet tuples, List<VarDef> vars) {
        boolean complete;
        List<VarDef> varsRemaining = this.getVarsRemaining(vars, testCase);
        if (varsRemaining.isEmpty()) {
            complete = true;
        } else {
            VarDef varApplicable = varsRemaining.stream().filter(v -> testCase.isApplicable((VarDef)v)).findFirst().orElse(null);
            if (varApplicable == null) {
                testCase.addCompatible(this.getNaBindingFor(varsRemaining.get(0)));
                complete = this.makeComplete(testCase, tuples, varsRemaining);
            } else {
                int prevBindings = testCase.getBindingCount();
                Iterator<Tuple> bindingTuples = this.getBindingsFor(tuples, varApplicable);
                complete = false;
                while (bindingTuples.hasNext() && (testCase.addCompatible(bindingTuples.next()) == null || testCase.isInfeasible() || !(complete = this.makeComplete(testCase, tuples, varsRemaining)))) {
                    testCase.revertBindings(prevBindings);
                }
            }
        }
        return complete;
    }

    private boolean makeSatisfied(TestCaseDef testCase, VarTupleSet tuples) {
        boolean satisfied = testCase.isSatisfied();
        if (!satisfied) {
            int prevBindings = testCase.getBindingCount();
            Iterator<Tuple> satisfyingTuples = this.getSatisfyingTuples(testCase, tuples);
            while (satisfyingTuples.hasNext() && !(satisfied = this.makeSatisfied(testCase, tuples, satisfyingTuples.next()))) {
                testCase.revertBindings(prevBindings);
            }
        }
        return satisfied;
    }

    private boolean makeSatisfied(TestCaseDef testCase, VarTupleSet tuples, Tuple satisfyingTuple) {
        return testCase.addCompatible(satisfyingTuple) != null && !testCase.isInfeasible() && this.makeSatisfied(testCase, tuples);
    }

    private Iterator<Tuple> getBindingsFor(VarTupleSet tuples, VarDef var) {
        return IteratorUtils.chainedIterator(tuples.getUnused(var), (Iterator)IteratorUtils.chainedIterator(tuples.getUsed(var), (Iterator)IteratorUtils.chainedIterator(tuples.getUsedOnce(var), this.getOneTuples(var))));
    }

    private Tuple getNaBindingFor(VarDef var) {
        return new Tuple(new VarBindingDef(var, VarNaDef.NA));
    }

    private Iterator<Tuple> getOneTuples(VarDef var) {
        return IteratorUtils.transformedIterator(var.getValidValues(), value -> Tuple.of(new VarBindingDef(var, (VarValueDef)value)));
    }

    private Iterator<Tuple> getSatisfyingTuples(TestCaseDef testCase, VarTupleSet varTupleSet) {
        Comparator<VarBindingDef> byUsage = this.byUsage(varTupleSet);
        return IteratorUtils.transformedIterator(new CartesianProduct(new ArrayList(CollectionUtils.collect(testCase.getRequired().getDisjuncts(), disjunct -> {
            Set unsatisfied = (Set)CollectionUtils.collect(disjunct.getAssertions(), assertion -> assertion.getProperty(), new HashSet());
            Iterator satisfyingBindings = IteratorUtils.filteredIterator(this.getPropertyProviders(unsatisfied).iterator(), binding -> testCase.isCompatible((VarBindingDef)binding));
            return (TreeSet)CollectionUtils.collect((Iterator)satisfyingBindings, (Transformer)NOPTransformer.nopTransformer(), new TreeSet(byUsage));
        }, new TreeSet<Set<VarBindingDef>>(varBindingSetSorter_))), bindings -> Tuple.of(bindings) != null), Tuple::of);
    }

    private List<VarDef> getVarsRemaining(FunctionInputDef inputDef, TestCaseDef testCase) {
        return this.getVarsRemaining(new VarDefIterator(inputDef), testCase);
    }

    private List<VarDef> getVarsRemaining(List<VarDef> vars, TestCaseDef testCase) {
        return this.getVarsRemaining(vars.iterator(), testCase);
    }

    private List<VarDef> getVarsRemaining(Iterator<VarDef> vars, TestCaseDef testCase) {
        return IteratorUtils.toList((Iterator)IteratorUtils.filteredIterator(vars, var -> testCase.getBinding((VarDef)var) == null));
    }

    private VarTupleSet getValidTupleSet(RandSeq randSeq, FunctionInputDef inputDef) {
        ArrayList<Tuple> validTuples = new ArrayList<Tuple>();
        this.getCombiners().stream().sorted(byTupleSize_).forEach(combiner -> validTuples.addAll(RandSeq.order(randSeq, combiner.getTuples(inputDef))));
        List uncombinedVars = IteratorUtils.toList((Iterator)IteratorUtils.filteredIterator((Iterator)new VarDefIterator(inputDef), this::isUncombined));
        if (!uncombinedVars.isEmpty()) {
            int defaultTupleSize = this.getDefaultTupleSize();
            int varCount = uncombinedVars.size();
            validTuples.addAll(RandSeq.order(randSeq, this.getUncombinedTuples(uncombinedVars, Math.min(varCount, defaultTupleSize < 1 ? varCount : defaultTupleSize))));
        }
        return new VarTupleSet(validTuples);
    }

    private boolean isUncombined(VarDef var) {
        return this.combiners_.stream().noneMatch(combiner -> combiner.isEligible(var));
    }

    private Collection<Tuple> getUncombinedTuples(List<VarDef> uncombinedVars, int defaultTupleSize) {
        Collection<Tuple> tuples = TupleCombiner.getTuples(uncombinedVars, defaultTupleSize);
        if (defaultTupleSize == 1) {
            Iterator<Tuple> iterator = tuples.iterator();
            while (iterator.hasNext()) {
                Tuple tuple;
                VarValueDef value = (tuple = iterator.next()).getBindings().next().getValueDef();
                tuple.setOnce(value.getType() == VarValueDef.Type.ONCE);
            }
        }
        return tuples;
    }

    private List<TestCaseDef> getFailureCases(FunctionInputDef inputDef, VarTupleSet failureTuples, VarTupleSet validTuples) {
        Tuple nextUnused;
        logger_.debug("{}: Creating failure test cases", (Object)inputDef);
        ArrayList<TestCaseDef> failureCases = new ArrayList<TestCaseDef>();
        while ((nextUnused = failureTuples.getNextUnused()) != null) {
            TestCaseDef failureCase = this.createTestCase(nextUnused, inputDef, validTuples);
            if (failureCase == null) continue;
            failureTuples.used(nextUnused);
            failureCases.add(failureCase);
        }
        logger_.info("{}: Created {} failure test cases", (Object)inputDef, (Object)failureCases.size());
        return failureCases;
    }

    private VarTupleSet getFailureTupleSet(RandSeq randSeq, FunctionInputDef inputDef) {
        ArrayList<Tuple> failureTuples = new ArrayList<Tuple>();
        VarDefIterator vars = new VarDefIterator(inputDef);
        while (vars.hasNext()) {
            VarDef var = vars.next();
            Iterator<VarValueDef> failures = var.getFailureValues();
            while (failures.hasNext()) {
                failureTuples.add(new Tuple(new VarBindingDef(var, failures.next())));
            }
        }
        return new VarTupleSet(RandSeq.reorderIf(randSeq, failureTuples));
    }

    private MultiValuedMap<String, VarBindingDef> createPropertyProviders(FunctionInputDef inputDef) {
        this.propertyProviders_ = MultiMapUtils.newListValuedHashMap();
        VarDefIterator varDefs = new VarDefIterator(inputDef.getVarDefs());
        while (varDefs.hasNext()) {
            VarDef varDef = varDefs.next();
            Iterator<VarValueDef> values = varDef.getValidValues();
            while (values.hasNext()) {
                VarValueDef value = values.next();
                if (!value.hasProperties()) continue;
                VarBindingDef binding = new VarBindingDef(varDef, value);
                Iterator<String> properties = value.getProperties().iterator();
                while (properties.hasNext()) {
                    this.propertyProviders_.put((Object)properties.next(), (Object)binding);
                }
            }
        }
        return this.propertyProviders_;
    }

    private Set<VarBindingDef> getPropertyProviders(Set<String> properties) {
        HashSet<VarBindingDef> bindings = new HashSet<VarBindingDef>();
        for (String property : properties) {
            bindings.addAll(this.propertyProviders_.get((Object)property));
        }
        return bindings;
    }

    public String toString() {
        return ToString.getBuilder(this).append("defaultTuples", this.getDefaultTupleSize()).append("seed", (Object)this.getRandomSeed()).toString();
    }

    private Comparator<VarBindingDef> byUsage(final VarTupleSet varTupleSet) {
        return new Comparator<VarBindingDef>(){
            private Map<VarBindingDef, Integer> bindingScores_ = new HashMap<VarBindingDef, Integer>();

            @Override
            public int compare(VarBindingDef binding1, VarBindingDef binding2) {
                int resultScore = this.getScore(binding2).compareTo(this.getScore(binding1));
                return resultScore == 0 ? varBindingDefSorter_.compare(binding1, binding2) : resultScore;
            }

            private Integer getScore(VarBindingDef binding) {
                Integer score = this.bindingScores_.get(binding);
                if (score == null) {
                    int maxScore = 1000;
                    int unusedScore = (int)(varTupleSet.getUnusedScore(binding) * (double)maxScore);
                    int usedScore = (int)((1.0 - varTupleSet.getUsedScore(binding)) * (double)(maxScore - 1));
                    int usedOnceScore = (int)((1.0 - varTupleSet.getUsedOnceScore(binding)) * (double)(maxScore - 1));
                    score = (unusedScore * maxScore + usedOnceScore) * maxScore + usedScore;
                    this.bindingScores_.put(binding, score);
                }
                return score;
            }
        };
    }

    @Override
    public ITestCaseGenerator cloneOf() {
        TupleGenerator other = new TupleGenerator();
        other.setRandomSeed(this.getRandomSeed());
        other.setDefaultTupleSize(this.getDefaultTupleSize());
        other.setCombiners(this.getCombiners().stream().map(TupleCombiner::cloneOf).collect(Collectors.toList()));
        return other;
    }

    public boolean equals(Object object) {
        TupleGenerator other = object != null && object.getClass().equals(this.getClass()) ? (TupleGenerator)object : null;
        return other != null && Objects.equals(other.getRandomSeed(), this.getRandomSeed()) && other.getDefaultTupleSize() == this.getDefaultTupleSize() && other.getCombiners().equals(this.getCombiners());
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ Objects.hashCode(this.getRandomSeed()) ^ this.getDefaultTupleSize() ^ this.getCombiners().hashCode();
    }
}

