/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.generator;

import java.util.stream.Stream;
import org.cornutum.tcases.generator.TupleCombiner;
import org.cornutum.tcases.generator.TupleRef;

public class TupleCombinerBuilder {
    TupleCombiner tupleCombiner_;

    public static TupleCombinerBuilder with(TupleCombiner tupleCombiner) {
        return new TupleCombinerBuilder(tupleCombiner);
    }

    public TupleCombinerBuilder() {
        this.start();
    }

    public TupleCombinerBuilder(TupleCombiner tupleCombiner) {
        this.start(tupleCombiner);
    }

    public TupleCombiner build() {
        return this.tupleCombiner_;
    }

    public TupleCombinerBuilder start() {
        return this.start(null);
    }

    public TupleCombinerBuilder start(TupleCombiner tupleCombiner) {
        this.tupleCombiner_ = tupleCombiner == null ? new TupleCombiner() : tupleCombiner;
        return this;
    }

    public TupleCombinerBuilder tuples(int tupleSize) {
        this.tupleCombiner_.setTupleSize(tupleSize);
        return this;
    }

    public TupleCombinerBuilder exclude(String ... varNamePatterns) {
        for (String varNamePattern : varNamePatterns) {
            this.tupleCombiner_.addExcludedVar(varNamePattern);
        }
        return this;
    }

    public TupleCombinerBuilder exclude(Iterable<String> varNamePatterns) {
        for (String varNamePattern : varNamePatterns) {
            this.tupleCombiner_.addExcludedVar(varNamePattern);
        }
        return this;
    }

    public TupleCombinerBuilder exclude(Stream<String> varNamePatterns) {
        varNamePatterns.forEach(varNamePattern -> this.tupleCombiner_.addExcludedVar((String)varNamePattern));
        return this;
    }

    public TupleCombinerBuilder include(String ... varNamePatterns) {
        for (String varNamePattern : varNamePatterns) {
            this.tupleCombiner_.addIncludedVar(varNamePattern);
        }
        return this;
    }

    public TupleCombinerBuilder include(Iterable<String> varNamePatterns) {
        for (String varNamePattern : varNamePatterns) {
            this.tupleCombiner_.addIncludedVar(varNamePattern);
        }
        return this;
    }

    public TupleCombinerBuilder include(Stream<String> varNamePatterns) {
        varNamePatterns.forEach(varNamePattern -> this.tupleCombiner_.addIncludedVar((String)varNamePattern));
        return this;
    }

    public TupleCombinerBuilder once(TupleRef ... tupleRefs) {
        for (TupleRef tupleRef : tupleRefs) {
            this.tupleCombiner_.addOnceTuple(tupleRef);
        }
        return this;
    }

    public TupleCombinerBuilder once(Iterable<TupleRef> tupleRefs) {
        for (TupleRef tupleRef : tupleRefs) {
            this.tupleCombiner_.addOnceTuple(tupleRef);
        }
        return this;
    }

    public TupleCombinerBuilder once(Stream<TupleRef> tupleRefs) {
        tupleRefs.forEach(tupleRef -> this.tupleCombiner_.addOnceTuple((TupleRef)tupleRef));
        return this;
    }
}

