/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.IteratorUtils;
import org.cornutum.tcases.FunctionInputDef;
import org.cornutum.tcases.IVarDef;
import org.cornutum.tcases.VarBinding;
import org.cornutum.tcases.VarBindingDef;
import org.cornutum.tcases.VarDef;
import org.cornutum.tcases.VarDefIterator;
import org.cornutum.tcases.VarValueDef;
import org.cornutum.tcases.generator.Tuple;
import org.cornutum.tcases.generator.TupleRef;
import org.cornutum.tcases.generator.VarNamePattern;
import org.cornutum.tcases.util.CloneableType;
import org.cornutum.tcases.util.ToString;

public class TupleCombiner
implements CloneableType<TupleCombiner> {
    private int tupleSize_;
    private Set<VarNamePattern> includedVars_;
    private Set<VarNamePattern> excludedVars_;
    private Set<TupleRef> onceTuples_;

    public TupleCombiner() {
        this(1);
    }

    public TupleCombiner(int tupleSize) {
        this.tupleSize_ = tupleSize;
        this.setIncludedVars(new HashSet<VarNamePattern>());
        this.setExcludedVars(new HashSet<VarNamePattern>());
        this.setOnceTuples(new HashSet<TupleRef>());
    }

    public void setTupleSize(int tupleSize) {
        Integer onceSize;
        Integer n = onceSize = this.onceTuples_.isEmpty() ? null : Integer.valueOf(this.getOnceTuples().next().size());
        if (onceSize != null && onceSize != tupleSize) {
            throw new IllegalArgumentException("Tuple size=" + tupleSize + " is not compatible with existing once-only tuple size=" + onceSize);
        }
        this.tupleSize_ = tupleSize;
    }

    public int getTupleSize() {
        return this.tupleSize_;
    }

    private void setIncludedVars(Set<VarNamePattern> varNamePatterns) {
        this.includedVars_ = varNamePatterns;
    }

    private Set<VarNamePattern> getIncludedVars() {
        return this.includedVars_;
    }

    public String[] getIncluded() {
        return (String[])IteratorUtils.toArray((Iterator)IteratorUtils.transformedIterator(this.includedVars_.iterator(), VarNamePattern::toString), String.class);
    }

    public TupleCombiner addIncludedVar(String varNamePattern) {
        this.getIncludedVars().add(this.getValidVarNamePattern(varNamePattern));
        return this;
    }

    public TupleCombiner removeIncludedVar(String varNamePattern) {
        this.getIncludedVars().remove(new VarNamePattern(varNamePattern));
        return this;
    }

    public TupleCombiner removeAllIncludedVars() {
        this.getIncludedVars().clear();
        return this;
    }

    private void setExcludedVars(Set<VarNamePattern> varNamePatterns) {
        this.excludedVars_ = varNamePatterns;
    }

    private Set<VarNamePattern> getExcludedVars() {
        return this.excludedVars_;
    }

    public String[] getExcluded() {
        return (String[])IteratorUtils.toArray((Iterator)IteratorUtils.transformedIterator(this.excludedVars_.iterator(), VarNamePattern::toString), String.class);
    }

    public TupleCombiner addExcludedVar(String varNamePattern) {
        this.getExcludedVars().add(this.getValidVarNamePattern(varNamePattern));
        return this;
    }

    public TupleCombiner removeExcludedVar(String varNamePattern) {
        this.getExcludedVars().remove(new VarNamePattern(varNamePattern));
        return this;
    }

    public TupleCombiner removeAllExcludedVars() {
        this.getExcludedVars().clear();
        return this;
    }

    private void setOnceTuples(Set<TupleRef> tupleRefs) {
        this.onceTuples_ = tupleRefs;
    }

    public Iterator<TupleRef> getOnceTuples() {
        return this.onceTuples_.iterator();
    }

    public TupleCombiner addOnceTuple(TupleRef tupleRef) {
        if (tupleRef != null) {
            if (tupleRef.size() != this.getTupleSize()) {
                throw new IllegalArgumentException("Once-only tuple=" + tupleRef + " has size=" + tupleRef.size() + ", expected size=" + this.getTupleSize());
            }
            this.onceTuples_.add(tupleRef);
        }
        return this;
    }

    public TupleCombiner removeOnceTuple(TupleRef tupleRef) {
        this.onceTuples_.remove(tupleRef);
        return this;
    }

    public TupleCombiner removeAllOnceTuples() {
        this.onceTuples_.clear();
        return this;
    }

    public Collection<Tuple> getTuples(FunctionInputDef inputDef) {
        List<VarDef> combinedVars = this.getCombinedVars(inputDef);
        return this.getCombinedTuples(combinedVars, TupleCombiner.getTuples(combinedVars, this.getTupleSize()));
    }

    public static Collection<Tuple> getTuples(List<VarDef> varDefs, int tupleSize) {
        int varEnd;
        if (tupleSize < 1) {
            tupleSize = varDefs.size();
        }
        if ((varEnd = varDefs.size() - tupleSize + 1) <= 0) {
            throw new IllegalArgumentException("Can't create " + tupleSize + "-tuples for " + varDefs.size() + " combined variables");
        }
        return TupleCombiner.getTuples(varDefs, 0, varEnd, tupleSize);
    }

    private static Collection<Tuple> getTuples(List<VarDef> varDefs, int varStart, int varEnd, int tupleSize) {
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        for (int i = varStart; i < varEnd; ++i) {
            Collection<Tuple> subTuples;
            VarDef nextVar = varDefs.get(i);
            Iterator<VarValueDef> values = nextVar.getValidValues();
            if (!values.hasNext()) {
                throw new IllegalStateException("Can't complete tuples -- no valid values defined for var=" + nextVar);
            }
            Collection<Tuple> collection = subTuples = tupleSize == 1 ? null : TupleCombiner.getTuples(varDefs, i + 1, varEnd + 1, tupleSize - 1);
            if (subTuples == null) {
                while (values.hasNext()) {
                    tuples.add(new Tuple(new VarBindingDef(nextVar, values.next())));
                }
                continue;
            }
            if (subTuples.isEmpty()) continue;
            while (values.hasNext()) {
                VarBindingDef nextBinding = new VarBindingDef(nextVar, values.next());
                for (Tuple subTuple : subTuples) {
                    Tuple nextTuple = new Tuple(nextBinding).addAll(subTuple);
                    if (!nextTuple.isCompatible()) continue;
                    tuples.add(nextTuple);
                }
            }
        }
        return tuples;
    }

    private Collection<Tuple> getCombinedTuples(List<VarDef> combinedVars, Collection<Tuple> tuples) {
        Set<Tuple> onceTuples = this.getOnceTupleDefs(combinedVars);
        if (!onceTuples.isEmpty()) {
            for (Tuple tuple : tuples) {
                tuple.setOnce(onceTuples.contains(tuple));
            }
        }
        return tuples;
    }

    private Set<Tuple> getOnceTupleDefs(List<VarDef> combinedVars) {
        try {
            return new HashSet<Tuple>(IteratorUtils.toList((Iterator)IteratorUtils.transformedIterator(this.getOnceTuples(), tupleRef -> this.toTuple(combinedVars, (TupleRef)tupleRef))));
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid once-only tuple definition", e);
        }
    }

    private Tuple toTuple(List<VarDef> combinedVars, TupleRef tupleRef) {
        if (tupleRef.size() != this.getTupleSize()) {
            throw new IllegalStateException(String.valueOf(tupleRef) + " does not match combiner tuple size=" + this.getTupleSize());
        }
        Tuple tuple = new Tuple();
        Iterator<VarBinding> bindings = tupleRef.getVarBindings();
        while (bindings.hasNext()) {
            VarBinding binding = bindings.next();
            VarDef var = this.findVarPath(combinedVars, binding.getVar());
            if (var == null) {
                throw new IllegalStateException("Var=" + binding.getVar() + " is not included in this combination");
            }
            VarValueDef value = var.getValue(binding.getValue());
            if (value == null) {
                throw new IllegalStateException("Value=" + binding.getValue() + " is not defined for var=" + binding.getVar());
            }
            if (!value.isValid()) {
                throw new IllegalStateException("Value=" + binding.getValue() + " is a failure value for var=" + binding.getVar());
            }
            tuple.add(new VarBindingDef(var, value));
        }
        return tuple;
    }

    private VarDef findVarPath(List<VarDef> combinedVars, String varPath) {
        int i;
        for (i = 0; i < combinedVars.size() && !varPath.equals(combinedVars.get(i).getPathName()); ++i) {
        }
        return i < combinedVars.size() ? combinedVars.get(i) : null;
    }

    public List<VarDef> getCombinedVars(FunctionInputDef inputDef) {
        this.assertApplicable(inputDef);
        ArrayList<VarDef> combinedVars = new ArrayList<VarDef>();
        VarDefIterator varDefs = new VarDefIterator(inputDef);
        while (varDefs.hasNext()) {
            VarDef varDef = varDefs.next();
            if (!this.isEligible(varDef)) continue;
            combinedVars.add(varDef);
        }
        if (combinedVars.size() < this.getTupleSize()) {
            throw new IllegalStateException("Can't return " + this.getTupleSize() + "-tuples for " + inputDef + ": only " + combinedVars.size() + " variables eligible for combination");
        }
        return combinedVars;
    }

    private boolean isExcluded(VarNamePattern varNamePath) {
        boolean excluded = false;
        Iterator<VarNamePattern> excludedVars = this.getExcludedVars().iterator();
        while (excludedVars.hasNext() && !(excluded = excludedVars.next().matches(varNamePath))) {
        }
        return excluded;
    }

    private boolean isIncluded(VarNamePattern varNamePath) {
        boolean included = this.getIncludedVars().isEmpty();
        if (!included) {
            Iterator<VarNamePattern> includedVars = this.getIncludedVars().iterator();
            while (includedVars.hasNext() && !(included = includedVars.next().matches(varNamePath))) {
            }
        }
        return included;
    }

    private void assertApplicable(FunctionInputDef inputDef) throws IllegalArgumentException {
        try {
            for (VarNamePattern varNamePattern : this.getIncludedVars()) {
                this.assertApplicable(inputDef, varNamePattern);
            }
            for (VarNamePattern varNamePattern : this.getExcludedVars()) {
                this.assertApplicable(inputDef, varNamePattern);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't apply " + this + " to " + inputDef, e);
        }
    }

    private void assertApplicable(FunctionInputDef inputDef, VarNamePattern varNamePattern) throws IllegalArgumentException {
        if (!varNamePattern.isApplicable(inputDef)) {
            throw new IllegalArgumentException("Can't find variable matching pattern=" + varNamePattern);
        }
    }

    public boolean isEligible(IVarDef varDef) {
        VarNamePattern varNamePath = new VarNamePattern(varDef.getPathName());
        return !this.isExcluded(varNamePath) && this.isIncluded(varNamePath);
    }

    private VarNamePattern getValidVarNamePattern(String varNamePattern) throws IllegalArgumentException {
        VarNamePattern pattern = new VarNamePattern(varNamePattern);
        if (!pattern.isValid()) {
            throw new IllegalArgumentException("\"" + pattern + "\" is not a valid variable name pattern");
        }
        return pattern;
    }

    public String toString() {
        return ToString.getBuilder(this).append("tuples", this.getTupleSize()).append("included", this.getIncludedVars()).append("excluded", this.getExcludedVars()).toString();
    }

    @Override
    public TupleCombiner cloneOf() {
        TupleCombiner other = new TupleCombiner();
        other.setTupleSize(this.getTupleSize());
        other.setIncludedVars(new HashSet<VarNamePattern>(this.getIncludedVars()));
        other.setExcludedVars(new HashSet<VarNamePattern>(this.getExcludedVars()));
        other.setOnceTuples(new HashSet<TupleRef>(IteratorUtils.toList(this.getOnceTuples())));
        return other;
    }

    public boolean equals(Object object) {
        TupleCombiner other = object != null && object.getClass().equals(this.getClass()) ? (TupleCombiner)object : null;
        return other != null && other.getTupleSize() == this.getTupleSize() && other.getIncludedVars().equals(this.getIncludedVars()) && other.getExcludedVars().equals(this.getExcludedVars()) && other.onceTuples_.equals(this.onceTuples_);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.getTupleSize() ^ this.getIncludedVars().hashCode() ^ this.getExcludedVars().hashCode() ^ this.onceTuples_.hashCode();
    }
}

