/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.generator;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.cornutum.tcases.PropertySet;
import org.cornutum.tcases.VarBindingDef;
import org.cornutum.tcases.VarDef;
import org.cornutum.tcases.VarValueDef;
import org.cornutum.tcases.util.ToString;

public class Tuple {
    private Map<VarDef, VarBindingDef> bindings_;
    private PropertySet properties_;
    private boolean once_;

    public Tuple() {
        this((Collection<VarBindingDef>)null);
    }

    public Tuple(Tuple other) {
        this();
        this.addAll(other);
        this.setOnce(other.isOnce());
    }

    public Tuple(VarBindingDef ... bindings) {
        this(Arrays.asList(bindings));
    }

    public Tuple(Collection<VarBindingDef> bindings) {
        this.setBindings(bindings);
    }

    public static Tuple of(VarBindingDef ... tupleBindings) {
        return Tuple.of(Arrays.asList(tupleBindings));
    }

    public static Tuple of(Collection<VarBindingDef> tupleBindings) {
        VarBindingDef nextBinding;
        Tuple tuple = new Tuple();
        Iterator<VarBindingDef> bindings = tupleBindings.iterator();
        boolean bindingsCompatible = true;
        while (bindings.hasNext() && (bindingsCompatible = Tuple.isBindingCompatible(tuple, nextBinding = bindings.next()))) {
            tuple.add(nextBinding);
        }
        return bindingsCompatible && tuple.isCompatible() ? tuple : null;
    }

    private static boolean isBindingCompatible(Tuple tuple, VarBindingDef binding) {
        VarValueDef currentValue = tuple.getBinding(binding.getVarDef());
        return currentValue == null || currentValue.equals(binding.getValueDef());
    }

    public void setBindings(Collection<VarBindingDef> bindings) {
        this.bindings_ = new HashMap<VarDef, VarBindingDef>();
        this.properties_ = new PropertySet();
        if (bindings != null) {
            for (VarBindingDef binding : bindings) {
                this.add(binding);
            }
        }
    }

    public Iterator<VarBindingDef> getBindings() {
        return this.bindings_.values().iterator();
    }

    public boolean contains(VarBindingDef binding) {
        return binding.equals(this.bindings_.get(binding.getVarDef()));
    }

    public VarValueDef getBinding(VarDef var) {
        VarBindingDef binding = this.bindings_.get(var);
        return binding == null ? null : binding.getValueDef();
    }

    public int size() {
        return this.bindings_.size();
    }

    public PropertySet getProperties() {
        return this.properties_;
    }

    public Tuple add(VarBindingDef binding) {
        if (binding != null) {
            VarDef var = binding.getVarDef();
            if (var == null) {
                throw new IllegalArgumentException("Invalid binding=" + binding + ": variable undefined");
            }
            VarValueDef value = binding.getValueDef();
            if (value == null) {
                throw new IllegalArgumentException("Invalid binding=" + binding + ": value undefined");
            }
            this.remove(var);
            this.bindings_.put(var, binding);
            this.properties_.addAll(value.getProperties().iterator());
        }
        return this;
    }

    public Tuple addAll(Tuple tuple) {
        if (tuple != null) {
            Iterator<VarBindingDef> bindings = tuple.getBindings();
            while (bindings.hasNext()) {
                this.add(bindings.next());
            }
        }
        return this;
    }

    public Tuple remove(VarDef var) {
        VarBindingDef binding = this.bindings_.remove(var);
        if (binding != null) {
            this.properties_.removeAll(binding.getValueDef().getProperties().iterator());
        }
        return this;
    }

    public void setOnce(boolean once) {
        this.once_ = once;
    }

    public boolean isOnce() {
        return this.once_;
    }

    public boolean isCompatible() {
        VarBindingDef binding = null;
        boolean compatible = true;
        Iterator<VarBindingDef> bindings = this.getBindings();
        while (compatible && bindings.hasNext()) {
            binding = bindings.next();
            compatible = binding.getEffectiveCondition().compatible(this.properties_);
        }
        if (!compatible && this.size() == 1) {
            throw new IllegalStateException("Invalid " + binding + ", value condition=" + binding.getValueDef().getCondition() + " is incompatible its own properties=" + binding.getValueDef().getProperties());
        }
        return compatible;
    }

    public boolean equals(Object object) {
        Tuple other = object != null && object.getClass().equals(this.getClass()) ? (Tuple)object : null;
        return other != null && Objects.equals(other.bindings_, this.bindings_);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.bindings_.hashCode();
    }

    public String toString() {
        ToStringBuilder builder = ToString.getBuilder(this);
        if (!this.bindings_.isEmpty()) {
            builder.append(this.bindings_.values());
        }
        return builder.toString();
    }
}

