/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cornutum.tcases.IVarDef;
import org.cornutum.tcases.PropertySet;
import org.cornutum.tcases.TestCase;
import org.cornutum.tcases.VarBinding;
import org.cornutum.tcases.VarBindingDef;
import org.cornutum.tcases.VarDef;
import org.cornutum.tcases.VarValueDef;
import org.cornutum.tcases.conditions.AllOf;
import org.cornutum.tcases.conditions.Cnf;
import org.cornutum.tcases.conditions.IAssertion;
import org.cornutum.tcases.conditions.ICondition;
import org.cornutum.tcases.conditions.IConjunct;
import org.cornutum.tcases.conditions.IDisjunct;
import org.cornutum.tcases.generator.BindingException;
import org.cornutum.tcases.generator.Tuple;
import org.cornutum.tcases.generator.ValueInconsistentException;
import org.cornutum.tcases.generator.ValueNotApplicableException;
import org.cornutum.tcases.generator.VarBoundException;
import org.cornutum.tcases.generator.VarNotApplicableException;
import org.cornutum.tcases.util.CollectionUtils;
import org.cornutum.tcases.util.ToString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCaseDef
implements Comparable<TestCaseDef> {
    private Integer id_;
    private String name_;
    private Map<VarDef, VarValueDef> bindings_ = new LinkedHashMap<VarDef, VarValueDef>();
    private PropertySet properties_ = new PropertySet();
    private IConjunct required_;
    private static final Logger logger_ = LoggerFactory.getLogger(TestCaseDef.class);

    public TestCaseDef() {
    }

    public TestCaseDef(TestCaseDef other) {
        this();
        if (other != null) {
            for (VarDef var : other.bindings_.keySet()) {
                this.addBinding(var, other.getBinding(var));
            }
        }
    }

    public void setId(Integer id) {
        this.id_ = id;
    }

    public Integer getId() {
        return this.id_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public void setName(Tuple tuple) {
        this.setName(CollectionUtils.toStream(tuple.getBindings()).map(VarBindingDef::getVarDef).sorted(Comparator.comparing(IVarDef::getPosition)).map(varDef -> String.format("%s=%s", varDef.getPathName(), CollectionUtils.toCsv(Stream.of(tuple.getBinding((VarDef)varDef).getName())))).collect(Collectors.joining("&")));
    }

    public String getName() {
        return this.name_;
    }

    public VarValueDef getValue(VarDef var) {
        return this.bindings_.get(var);
    }

    public boolean usesTuple(Tuple tuple) {
        boolean uses;
        Iterator<VarBindingDef> tupleBindings = tuple.getBindings();
        boolean bl = uses = tuple.size() > 0;
        while (uses && tupleBindings.hasNext()) {
            uses = this.usesBinding(tupleBindings.next());
        }
        return uses;
    }

    public boolean usesBinding(VarBindingDef binding) {
        return binding.getValueDef().equals(this.getValue(binding.getVarDef()));
    }

    public Tuple addCompatible(Tuple tuple) {
        Tuple newBindings = null;
        try {
            newBindings = Optional.of(this.addBindings(tuple)).filter(added -> added.size() > 0).orElse(null);
            if (newBindings != null) {
                logger_.trace("Adding tuple={}, testCase={}", (Object)tuple, (Object)this);
            }
        }
        catch (BindingException be) {
            logger_.trace("Can't add tuple={}: {}, testCase={}", new Object[]{tuple, be.getMessage(), this});
        }
        return newBindings;
    }

    public boolean isCompatible(Tuple tuple) {
        boolean compatible;
        try {
            this.checkCompatible(tuple);
            compatible = true;
        }
        catch (BindingException be) {
            compatible = false;
        }
        return compatible;
    }

    public boolean isCompatible(VarBindingDef binding) {
        boolean compatible;
        try {
            this.checkCompatible(binding);
            compatible = true;
        }
        catch (BindingException e) {
            compatible = false;
        }
        return compatible;
    }

    public boolean isApplicable(VarDef var) {
        return var.getEffectiveCondition().satisfied(this.properties_);
    }

    public Tuple addBindings(Tuple tuple) throws BindingException {
        this.checkCompatible(tuple);
        Tuple newBindings = new Tuple();
        Iterator<VarBindingDef> bindings = tuple.getBindings();
        while (bindings.hasNext()) {
            VarBindingDef binding = bindings.next();
            if (!this.addBinding(binding)) continue;
            newBindings.add(binding);
        }
        return newBindings;
    }

    public void removeBindings(Tuple tuple) {
        Iterator<VarBindingDef> bindings = tuple.getBindings();
        while (bindings.hasNext()) {
            this.removeBinding(bindings.next());
        }
    }

    public void revertBindings(int prevCount) {
        CollectionUtils.toStream(this.getVars()).collect(Collectors.toList()).subList(prevCount, this.getBindingCount()).stream().forEach(var -> this.removeBinding((VarDef)var));
    }

    private void checkCompatible(Tuple tuple) throws BindingException {
        Iterator<VarBindingDef> bindings = tuple.getBindings();
        while (bindings.hasNext()) {
            this.checkCompatible(bindings.next());
        }
    }

    private void checkCompatible(VarBindingDef binding) throws BindingException {
        VarDef var = binding.getVarDef();
        VarValueDef value = binding.getValueDef();
        VarValueDef prevValue = this.bindings_.get(var);
        if (prevValue != null) {
            if (!value.equals(prevValue)) {
                throw new VarBoundException(binding, prevValue);
            }
        } else if (!value.isNA()) {
            if (!var.getEffectiveCondition().compatible(this.properties_)) {
                throw new VarNotApplicableException(binding, this.properties_);
            }
            boolean valueCompatible = Optional.ofNullable(value.getCondition()).map(c -> c.compatible(this.properties_)).orElse(true);
            if (!valueCompatible) {
                throw new ValueInconsistentException(binding, this.properties_);
            }
            VarDef inapplicable = this.getVarInapplicable(value);
            if (inapplicable != null) {
                throw new ValueNotApplicableException(binding, inapplicable);
            }
        }
    }

    private VarDef getVarInapplicable(VarValueDef value) {
        PropertySet properties = new PropertySet().addAll(value.getProperties().iterator()).addAll(this.properties_);
        VarDef inapplicable = null;
        Iterator<VarDef> vars = this.getVars();
        while (vars.hasNext() && (this.isNA(inapplicable = vars.next()) || inapplicable.getEffectiveCondition().compatible(properties))) {
            inapplicable = null;
        }
        return inapplicable;
    }

    private boolean addBinding(VarBindingDef binding) {
        boolean added;
        VarDef var = binding.getVarDef();
        boolean bl = added = !this.bindings_.containsKey(var);
        if (added) {
            this.addBinding(var, binding.getValueDef());
        }
        return added;
    }

    private void addBinding(VarDef var, VarValueDef value) {
        this.bindings_.put(var, value);
        this.properties_.addAll(value.getProperties().iterator());
        this.required_ = null;
    }

    private void removeBinding(VarBindingDef binding) {
        this.removeBinding(binding.getVarDef());
    }

    private void removeBinding(VarDef var) {
        VarValueDef value = this.bindings_.remove(var);
        logger_.trace("Removing binding for {}={}, testCase={}", new Object[]{var.getName(), value.isNA() ? "N/A" : value.getName(), this});
        if (value != null) {
            this.properties_.removeAll(value.getProperties().iterator());
            this.required_ = null;
        }
    }

    public Iterator<VarDef> getVars() {
        return this.bindings_.keySet().iterator();
    }

    public VarValueDef getBinding(VarDef var) {
        return this.bindings_.get(var);
    }

    public int getBindingCount() {
        return this.bindings_.size();
    }

    public boolean isNA(VarDef var) {
        return this.getBinding(var).isNA();
    }

    public VarDef getInvalidVar() {
        Iterator<VarDef> vars = this.getVars();
        VarDef invalidVar = null;
        while (vars.hasNext() && this.getValue(invalidVar = vars.next()).isValid()) {
            invalidVar = null;
        }
        return invalidVar;
    }

    public IConjunct getRequired() {
        if (this.required_ == null) {
            AllOf conditions = new AllOf(new ICondition[0]);
            Iterator<VarDef> vars = this.getVars();
            while (vars.hasNext()) {
                VarDef var = vars.next();
                VarValueDef value = this.getBinding(var);
                if (value.isNA()) continue;
                ICondition bindingCondition = value.getEffectiveCondition(var.getEffectiveCondition());
                Optional.of(bindingCondition).filter(c -> c instanceof AllOf).map(c -> CollectionUtils.toStream(((AllOf)c).getConditions())).orElse(Stream.of(bindingCondition)).forEach(c -> conditions.add((ICondition)c));
            }
            this.required_ = Cnf.getUnsatisfied(Cnf.convert(conditions), this.properties_);
        }
        return this.required_;
    }

    public boolean isSatisfied() {
        return this.getRequired().getDisjunctCount() == 0;
    }

    public boolean isInfeasible() {
        IAssertion unsatisfiable = null;
        Iterator<IDisjunct> disjuncts = this.getRequired().getDisjuncts();
        while (unsatisfiable == null && disjuncts.hasNext()) {
            Iterator<IAssertion> assertions = disjuncts.next().getAssertions();
            while (assertions.hasNext() && (unsatisfiable = assertions.next()).completable()) {
                unsatisfiable = null;
            }
        }
        if (unsatisfiable != null) {
            logger_.trace("Infeasible, can no longer satisfy {}, testCase={}", unsatisfiable, (Object)this);
        }
        return unsatisfiable != null;
    }

    public TestCase createTestCase(int id) {
        TestCase testCase = new TestCase(id);
        testCase.setName(this.getName());
        for (VarDef var : this.bindings_.keySet()) {
            testCase.addVarBinding(VarBinding.create(var, this.bindings_.get(var)));
        }
        this.propertyStream().reduce((properties, property) -> properties + "," + property).ifPresent(properties -> testCase.setAnnotation("properties", (String)properties));
        return testCase;
    }

    private Stream<String> propertyStream() {
        return CollectionUtils.toStream(this.properties_.getUniqueProperties()).sorted(String.CASE_INSENSITIVE_ORDER);
    }

    @Override
    public int compareTo(TestCaseDef other) {
        int id = this.getId() == null ? Integer.MAX_VALUE : this.getId();
        int otherId = other.getId() == null ? Integer.MAX_VALUE : other.getId();
        return id - otherId;
    }

    public String toString() {
        ArrayList<VarDef> vars = new ArrayList<VarDef>(this.bindings_.keySet());
        Collections.sort(vars, new Comparator<VarDef>(){

            @Override
            public int compare(VarDef v1, VarDef v2) {
                return v1.getPosition().compareTo(v2.getPosition());
            }
        });
        StringBuilder bindings = new StringBuilder("[");
        for (VarDef var : vars) {
            if (bindings.length() > 1) {
                bindings.append(", ");
            }
            bindings.append(var.getName()).append('=').append(this.bindings_.get(var).getName());
        }
        bindings.append(']');
        return ToString.getBuilder(this).append("id", (Object)this.getId()).append("name", (Object)this.getName()).append("bindings", (Object)bindings.toString()).append("properties", (Object)this.properties_).toString();
    }
}

