/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.commons.collections4.IteratorUtils;

public class RandSeq {
    private Random generator_;

    public RandSeq(Random generator) {
        this.generator_ = generator;
    }

    public RandSeq() {
        this(new Random());
    }

    public RandSeq(long seed) {
        this(new Random(seed));
    }

    public <T> List<T> reorder(List<T> sequence) {
        int elementCount = sequence.size();
        if (elementCount > 1) {
            ArrayList<T> elements = new ArrayList<T>(sequence);
            sequence.clear();
            while (elementCount > 0) {
                sequence.add(elements.remove(this.generator_.nextInt(elementCount)));
                --elementCount;
            }
        }
        return sequence;
    }

    public <T> Iterator<T> reorder(Iterator<T> sequence) {
        return this.reorder(IteratorUtils.toList(sequence)).iterator();
    }

    public static <T> List<T> reorderIf(RandSeq randSeq, List<T> sequence) {
        return randSeq == null ? sequence : randSeq.reorder(sequence);
    }

    public static <T> List<T> order(RandSeq randSeq, Collection<T> collection) {
        return RandSeq.reorderIf(randSeq, new ArrayList<T>(collection));
    }

    public static <T> Iterator<T> reorderIf(RandSeq randSeq, Iterator<T> sequence) {
        return randSeq == null ? sequence : randSeq.reorder(sequence);
    }
}

