/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.generator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.cornutum.tcases.generator.IGeneratorSet;
import org.cornutum.tcases.generator.ITestCaseGenerator;
import org.cornutum.tcases.generator.TupleGenerator;
import org.cornutum.tcases.util.CloneableType;
import org.cornutum.tcases.util.ToString;

public class GeneratorSet
implements IGeneratorSet,
CloneableType<GeneratorSet> {
    private Map<String, ITestCaseGenerator> generators_ = new HashMap<String, ITestCaseGenerator>();
    public static final String ALL = "*";

    @Override
    public ITestCaseGenerator getGenerator(String functionName) {
        ITestCaseGenerator generator = this.generators_.get(this.getFunctionKey(functionName));
        return generator == null ? this.generators_.get(ALL) : generator;
    }

    @Override
    public String[] getGeneratorFunctions() {
        String[] functions = new String[this.generators_.size()];
        this.generators_.keySet().toArray(functions);
        return functions;
    }

    @Override
    public Iterator<ITestCaseGenerator> getGenerators() {
        return this.generators_.values().iterator();
    }

    public void addGenerator(String functionName, ITestCaseGenerator generator) {
        String functionKey = this.getFunctionKey(functionName);
        if (this.generators_.containsKey(functionKey)) {
            throw new IllegalArgumentException("Generator already defined for function=" + functionName);
        }
        if (generator != null) {
            this.generators_.put(functionKey, generator);
        }
    }

    public void setGenerator(String functionName, ITestCaseGenerator generator) {
        String functionKey = this.getFunctionKey(functionName);
        if (generator == null) {
            this.generators_.remove(functionKey);
        } else {
            this.generators_.put(functionKey, generator);
        }
    }

    public static GeneratorSet basicGenerator() {
        GeneratorSet genSet = new GeneratorSet();
        genSet.addGenerator(ALL, new TupleGenerator());
        return genSet;
    }

    private String getFunctionKey(String functionName) {
        return (functionName = StringUtils.trimToNull((String)functionName)) == null ? ALL : functionName;
    }

    @Override
    public GeneratorSet cloneOf() {
        GeneratorSet clone = new GeneratorSet();
        this.generators_.forEach((f, g) -> clone.setGenerator((String)f, (ITestCaseGenerator)g.cloneOf()));
        return clone;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.generators_.hashCode();
    }

    public boolean equals(Object object) {
        GeneratorSet other = object != null && object.getClass().equals(this.getClass()) ? (GeneratorSet)object : null;
        return other != null && other.generators_.equals(this.generators_);
    }

    public String toString() {
        return ToString.getBuilder(this).append("functions", this.generators_.keySet()).toString();
    }
}

