/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.conditions;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.cornutum.tcases.util.ToString;

public abstract class PropertyExpr {
    private Set<String> properties_ = new HashSet<String>();

    protected PropertyExpr(String ... properties) {
        this(Arrays.asList(properties));
    }

    protected PropertyExpr(Collection<String> properties) {
        this.addProperties(properties);
    }

    public void addProperty(String property) {
        String candidate = StringUtils.trimToNull((String)property);
        if (candidate != null) {
            this.properties_.add(property);
        }
    }

    public void addProperties(Collection<String> properties) {
        for (String property : properties) {
            this.addProperty(property);
        }
    }

    public void removeProperty(String property) {
        this.properties_.remove(property);
    }

    public Iterator<String> getProperties() {
        return this.properties_.iterator();
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ Objects.hashCode(this.properties_);
    }

    public boolean equals(Object object) {
        PropertyExpr other = object != null && object.getClass().equals(this.getClass()) ? (PropertyExpr)object : null;
        return other != null && Objects.equals(other.properties_, this.properties_);
    }

    public String toString() {
        return ToString.getBuilder(this).append(this.properties_).toString();
    }
}

