/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.conditions;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.iterators.SingletonIterator;
import org.cornutum.tcases.PropertySet;
import org.cornutum.tcases.conditions.IAssertion;
import org.cornutum.tcases.conditions.IConditionVisitor;
import org.cornutum.tcases.conditions.IDisjunct;
import org.cornutum.tcases.util.ToString;

public class Disjunction
implements IDisjunct {
    private Set<IAssertion> assertions_ = new HashSet<IAssertion>();

    public Disjunction(IAssertion ... assertions) {
        for (int i = 0; i < assertions.length; ++i) {
            this.add(assertions[i]);
        }
    }

    public Disjunction(IDisjunct ... disjuncts) {
        for (int i = 0; i < disjuncts.length; ++i) {
            this.add(disjuncts[i]);
        }
    }

    @Override
    public boolean satisfied(PropertySet properties) {
        boolean isSatisfied;
        Iterator<IAssertion> assertions = this.getAssertions();
        boolean bl = isSatisfied = !assertions.hasNext();
        while (!isSatisfied && assertions.hasNext()) {
            isSatisfied = assertions.next().satisfied(properties);
        }
        return isSatisfied;
    }

    @Override
    public boolean compatible(PropertySet properties) {
        boolean isCompatible;
        Iterator<IAssertion> assertions = this.getAssertions();
        boolean bl = isCompatible = !assertions.hasNext();
        while (!isCompatible && assertions.hasNext()) {
            isCompatible = assertions.next().compatible(properties);
        }
        return isCompatible;
    }

    @Override
    public void accept(IConditionVisitor visitor) {
        visitor.visit(this);
    }

    public Disjunction add(IAssertion assertion) {
        this.assertions_.add(assertion);
        return this;
    }

    public Disjunction add(IDisjunct disjunct) {
        Iterator<IAssertion> assertions = disjunct.getAssertions();
        while (assertions.hasNext()) {
            this.add(assertions.next());
        }
        return this;
    }

    public Disjunction remove(IAssertion assertion) {
        this.assertions_.remove(assertion);
        return this;
    }

    @Override
    public Iterator<IAssertion> getAssertions() {
        return this.assertions_.iterator();
    }

    @Override
    public boolean contains(IAssertion assertion) {
        return this.assertions_.contains(assertion);
    }

    @Override
    public int getAssertionCount() {
        return this.assertions_.size();
    }

    @Override
    public Iterator<IDisjunct> getDisjuncts() {
        return new SingletonIterator((Object)this);
    }

    @Override
    public int getDisjunctCount() {
        return 1;
    }

    public String toString() {
        return ToString.getBuilder(this).append(this.assertions_).toString();
    }

    public int hashCode() {
        return this.assertions_.hashCode();
    }

    public boolean equals(Object object) {
        IDisjunct other = object != null && object instanceof IDisjunct ? (IDisjunct)object : null;
        return other != null && this.assertions_.equals(new HashSet(IteratorUtils.toList(other.getAssertions())));
    }
}

