/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.conditions;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections4.IteratorUtils;
import org.cornutum.tcases.PropertySet;
import org.cornutum.tcases.conditions.IConditionVisitor;
import org.cornutum.tcases.conditions.IConjunct;
import org.cornutum.tcases.conditions.IDisjunct;
import org.cornutum.tcases.util.ToString;

public class Conjunction
implements IConjunct {
    private Set<IDisjunct> disjuncts_ = new HashSet<IDisjunct>();

    public Conjunction(IDisjunct ... disjuncts) {
        for (int i = 0; i < disjuncts.length; ++i) {
            this.add(disjuncts[i]);
        }
    }

    @Override
    public boolean satisfied(PropertySet properties) {
        Iterator<IDisjunct> disjuncts = this.getDisjuncts();
        boolean isSatisfied = true;
        while (isSatisfied && disjuncts.hasNext()) {
            isSatisfied = disjuncts.next().satisfied(properties);
        }
        return isSatisfied;
    }

    @Override
    public boolean compatible(PropertySet properties) {
        Iterator<IDisjunct> disjuncts = this.getDisjuncts();
        boolean isCompatible = true;
        while (isCompatible && disjuncts.hasNext()) {
            isCompatible = disjuncts.next().compatible(properties);
        }
        return isCompatible;
    }

    @Override
    public void accept(IConditionVisitor visitor) {
        visitor.visit(this);
    }

    public Conjunction add(IDisjunct disjunct) {
        if (disjunct.getAssertionCount() > 0) {
            this.disjuncts_.add(disjunct);
        }
        return this;
    }

    public Conjunction append(IConjunct conjunct) {
        Iterator<IDisjunct> disjuncts = conjunct.getDisjuncts();
        while (disjuncts.hasNext()) {
            this.add(disjuncts.next());
        }
        return this;
    }

    public Conjunction remove(IDisjunct disjunct) {
        this.disjuncts_.remove(disjunct);
        return this;
    }

    @Override
    public Iterator<IDisjunct> getDisjuncts() {
        return this.disjuncts_.iterator();
    }

    @Override
    public int getDisjunctCount() {
        return this.disjuncts_.size();
    }

    public String toString() {
        return ToString.getBuilder(this).append(this.disjuncts_).toString();
    }

    public int hashCode() {
        return this.disjuncts_.hashCode();
    }

    public boolean equals(Object object) {
        IConjunct other = object != null && object instanceof IConjunct ? (IConjunct)object : null;
        return other != null && this.disjuncts_.equals(new HashSet(IteratorUtils.toList(other.getDisjuncts())));
    }
}

