/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.conditions;

import java.util.stream.Stream;
import org.cornutum.tcases.conditions.AllOf;
import org.cornutum.tcases.conditions.AnyOf;
import org.cornutum.tcases.conditions.AssertLess;
import org.cornutum.tcases.conditions.AssertMore;
import org.cornutum.tcases.conditions.AssertNotLess;
import org.cornutum.tcases.conditions.AssertNotMore;
import org.cornutum.tcases.conditions.Between;
import org.cornutum.tcases.conditions.BoundedAssertion;
import org.cornutum.tcases.conditions.ContainsAll;
import org.cornutum.tcases.conditions.ContainsAny;
import org.cornutum.tcases.conditions.Equals;
import org.cornutum.tcases.conditions.ICondition;
import org.cornutum.tcases.conditions.IConditionVisitor;
import org.cornutum.tcases.conditions.IConjunct;
import org.cornutum.tcases.conditions.Not;
import org.cornutum.tcases.util.CollectionUtils;

public final class Conditions {
    private Conditions() {
    }

    public static AllOf allOf(ICondition ... conditions) {
        return new AllOf(conditions);
    }

    public static AnyOf anyOf(ICondition ... conditions) {
        return new AnyOf(conditions);
    }

    public static Not not(ICondition ... conditions) {
        return new Not(conditions);
    }

    public static ContainsAll has(String ... properties) {
        return new ContainsAll(properties);
    }

    public static ContainsAny hasAny(String ... properties) {
        return new ContainsAny(properties);
    }

    public static AllOf allOf(String ... properties) {
        return Conditions.allOf(Conditions.has(properties));
    }

    public static AnyOf anyOf(String ... properties) {
        return Conditions.anyOf(Conditions.hasAny(properties));
    }

    public static Not not(String ... properties) {
        return Conditions.not(Conditions.hasAny(properties));
    }

    public static AssertMore moreThan(String property, int minimum) {
        return new AssertMore(property, minimum);
    }

    public static AssertLess lessThan(String property, int maximum) {
        return new AssertLess(property, maximum);
    }

    public static AssertNotMore notMoreThan(String property, int maximum) {
        return new AssertNotMore(property, maximum);
    }

    public static AssertNotLess notLessThan(String property, int minimum) {
        return new AssertNotLess(property, minimum);
    }

    public static Between between(String property, int minimum, int maximum) {
        return new Between(Conditions.notLessThan(property, minimum), Conditions.notMoreThan(property, maximum));
    }

    public static Between betweenExclusive(String property, int minimum, int maximum) {
        return new Between(Conditions.moreThan(property, minimum), Conditions.lessThan(property, maximum));
    }

    public static Between betweenExclusiveMin(String property, int minimum, int maximum) {
        return new Between(Conditions.moreThan(property, minimum), Conditions.notMoreThan(property, maximum));
    }

    public static Between betweenExclusiveMax(String property, int minimum, int maximum) {
        return new Between(Conditions.notLessThan(property, minimum), Conditions.lessThan(property, maximum));
    }

    public static Equals equalTo(String property, int count) {
        return new Equals(property, count);
    }

    public static Stream<String> propertiesReferenced(ICondition condition) {
        if (condition == null) {
            return Stream.empty();
        }
        PropertyVisitor propertyVisitor = new PropertyVisitor();
        condition.accept(propertyVisitor);
        return propertyVisitor.propertiesVisited();
    }

    private static class PropertyVisitor
    implements IConditionVisitor {
        private Stream.Builder<String> refBuilder_ = Stream.builder();

        private PropertyVisitor() {
        }

        @Override
        public void visit(AllOf condition) {
            CollectionUtils.toStream(condition.getConditions()).flatMap(c -> Conditions.propertiesReferenced(c)).forEach(p -> this.refBuilder_.add((String)p));
        }

        @Override
        public void visit(AnyOf condition) {
            CollectionUtils.toStream(condition.getConditions()).flatMap(c -> Conditions.propertiesReferenced(c)).forEach(p -> this.refBuilder_.add((String)p));
        }

        @Override
        public void visit(ContainsAll condition) {
            CollectionUtils.toStream(condition.getProperties()).forEach(p -> this.refBuilder_.add((String)p));
        }

        @Override
        public void visit(ContainsAny condition) {
            CollectionUtils.toStream(condition.getProperties()).forEach(p -> this.refBuilder_.add((String)p));
        }

        @Override
        public void visit(IConjunct condition) {
        }

        @Override
        public void visit(Not condition) {
            CollectionUtils.toStream(condition.getConditions()).flatMap(c -> Conditions.propertiesReferenced(c)).forEach(p -> this.refBuilder_.add((String)p));
        }

        @Override
        public void visit(AssertLess condition) {
            this.visitBoundedAssertion(condition);
        }

        @Override
        public void visit(AssertMore condition) {
            this.visitBoundedAssertion(condition);
        }

        @Override
        public void visit(AssertNotLess condition) {
            this.visitBoundedAssertion(condition);
        }

        @Override
        public void visit(AssertNotMore condition) {
            this.visitBoundedAssertion(condition);
        }

        @Override
        public void visit(Between condition) {
            this.visit((AllOf)condition);
        }

        @Override
        public void visit(Equals condition) {
            this.visit((AllOf)condition);
        }

        private void visitBoundedAssertion(BoundedAssertion condition) {
            this.refBuilder_.add(condition.getProperty());
        }

        public Stream<String> propertiesVisited() {
            return this.refBuilder_.build().distinct();
        }
    }
}

