/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.conditions;

import java.util.Iterator;
import org.apache.commons.collections4.IteratorUtils;
import org.cornutum.tcases.PropertySet;
import org.cornutum.tcases.conditions.AllOf;
import org.cornutum.tcases.conditions.AnyOf;
import org.cornutum.tcases.conditions.Assert;
import org.cornutum.tcases.conditions.AssertLess;
import org.cornutum.tcases.conditions.AssertMore;
import org.cornutum.tcases.conditions.AssertNotLess;
import org.cornutum.tcases.conditions.AssertNotMore;
import org.cornutum.tcases.conditions.Between;
import org.cornutum.tcases.conditions.Conjunction;
import org.cornutum.tcases.conditions.ContainsAll;
import org.cornutum.tcases.conditions.ContainsAny;
import org.cornutum.tcases.conditions.Disjunction;
import org.cornutum.tcases.conditions.Equals;
import org.cornutum.tcases.conditions.IAssertion;
import org.cornutum.tcases.conditions.ICondition;
import org.cornutum.tcases.conditions.IConditionVisitor;
import org.cornutum.tcases.conditions.IConjunct;
import org.cornutum.tcases.conditions.IDisjunct;
import org.cornutum.tcases.conditions.Not;

public abstract class Cnf {
    public static IConjunct negate(IConjunct conjunct) {
        AnyOf anyOf = new AnyOf(new ICondition[0]);
        Iterator<IDisjunct> disjuncts = conjunct.getDisjuncts();
        while (disjuncts.hasNext()) {
            Conjunction conjunction = new Conjunction(new IDisjunct[0]);
            Iterator<IAssertion> assertions = disjuncts.next().getAssertions();
            while (assertions.hasNext()) {
                conjunction.add(assertions.next().negate());
            }
            anyOf.add(Cnf.simplify(conjunction));
        }
        return Cnf.convert(anyOf);
    }

    public static IConjunct either(IConjunct conjunct1, IConjunct conjunct2) {
        IConjunct conjunct;
        if (conjunct1.getDisjunctCount() == 0) {
            conjunct = conjunct2;
        } else if (conjunct2.getDisjunctCount() == 0) {
            conjunct = conjunct1;
        } else {
            Conjunction conjunction = new Conjunction(new IDisjunct[0]);
            Iterator<IDisjunct> disjuncts1 = conjunct1.getDisjuncts();
            while (disjuncts1.hasNext()) {
                IDisjunct disjunct1 = disjuncts1.next();
                Iterator<IDisjunct> disjuncts2 = conjunct2.getDisjuncts();
                while (disjuncts2.hasNext()) {
                    Disjunction disjunct = new Disjunction(disjunct1, disjuncts2.next());
                    if (Cnf.isTautology(disjunct)) continue;
                    conjunction.add(Cnf.simplify(disjunct));
                }
            }
            conjunct = Cnf.simplify(conjunction);
        }
        return conjunct;
    }

    public static IConjunct refactor(IConjunct conjunct) {
        Iterator<IDisjunct> disjuncts = conjunct.getDisjuncts();
        IAssertion assertion = null;
        while (disjuncts.hasNext() && (assertion = Cnf.toAssertion(disjuncts.next())) == null) {
        }
        return assertion == null ? conjunct : Cnf.simplify(new Conjunction(assertion).append(Cnf.refactor(Cnf.remainder(conjunct, assertion))));
    }

    public static IConjunct remainder(IConjunct conjunct, IAssertion assertion) {
        Conjunction rest = new Conjunction(new IDisjunct[0]);
        Iterator<IDisjunct> disjuncts = conjunct.getDisjuncts();
        while (disjuncts.hasNext()) {
            IDisjunct disjunct = disjuncts.next();
            if (disjunct.contains(assertion)) continue;
            rest.add(disjunct);
        }
        return rest;
    }

    public static IAssertion toAssertion(IDisjunct disjunct) {
        return disjunct.getAssertionCount() == 1 ? disjunct.getAssertions().next() : null;
    }

    public static IConjunct simplify(IConjunct conjunct) {
        return conjunct.getDisjunctCount() == 1 ? (IConjunct)conjunct.getDisjuncts().next() : conjunct;
    }

    public static IDisjunct simplify(IDisjunct disjunct) {
        IAssertion assertion = Cnf.toAssertion(disjunct);
        return assertion == null ? disjunct : assertion;
    }

    public static boolean isTautology(IDisjunct disjunct) {
        boolean tautology = false;
        if (disjunct != null) {
            IAssertion[] assertions = (IAssertion[])IteratorUtils.toArray(disjunct.getAssertions(), IAssertion.class);
            int max = assertions.length;
            int maxCompared = max - 1;
            for (int compared = 0; !tautology && compared < maxCompared; ++compared) {
                IAssertion assertCompared = assertions[compared];
                int other = compared + 1;
                while (!tautology && other < max) {
                    tautology = assertCompared.negates(assertions[other++]);
                }
            }
        }
        return tautology;
    }

    public static IConjunct convert(ICondition condition) {
        return new Converter().convert(condition);
    }

    public static boolean satisfiesSome(IConjunct condition, PropertySet properties) {
        boolean satisfies;
        Iterator<IDisjunct> disjuncts = condition.getDisjuncts();
        boolean bl = satisfies = !disjuncts.hasNext();
        while (!satisfies && disjuncts.hasNext()) {
            satisfies = disjuncts.next().satisfied(properties);
        }
        return satisfies;
    }

    public static IConjunct getUnsatisfied(IConjunct condition, PropertySet properties) {
        Conjunction unsatisfied = new Conjunction(new IDisjunct[0]);
        Iterator<IDisjunct> disjuncts = condition.getDisjuncts();
        while (disjuncts.hasNext()) {
            IDisjunct disjunct = disjuncts.next();
            if (disjunct.satisfied(properties)) continue;
            unsatisfied.add(disjunct);
        }
        return unsatisfied;
    }

    public static class Converter
    implements IConditionVisitor {
        private IConjunct conjunct_;

        public IConjunct convert(ICondition condition) {
            this.conjunct_ = null;
            condition.accept(this);
            return Cnf.refactor(this.conjunct_);
        }

        @Override
        public void visit(AllOf condition) {
            Conjunction conjunction = new Conjunction(new IDisjunct[0]);
            Iterator<ICondition> conditions = condition.getConditions();
            while (conditions.hasNext()) {
                IConjunct conjunct = Cnf.convert(conditions.next());
                Iterator<IDisjunct> disjuncts = conjunct.getDisjuncts();
                while (disjuncts.hasNext()) {
                    IDisjunct disjunct = disjuncts.next();
                    if (Cnf.isTautology(disjunct)) continue;
                    conjunction.add(disjunct);
                }
            }
            this.conjunct_ = Cnf.simplify(conjunction);
        }

        @Override
        public void visit(AnyOf condition) {
            IConjunct conjunct = new Conjunction(new IDisjunct[0]);
            Iterator<ICondition> conditions = condition.getConditions();
            while (conditions.hasNext()) {
                conjunct = Cnf.either(conjunct, Cnf.convert(conditions.next()));
            }
            this.conjunct_ = Cnf.simplify(conjunct);
        }

        @Override
        public void visit(ContainsAll condition) {
            Conjunction conjunction = new Conjunction(new IDisjunct[0]);
            Iterator<String> properties = condition.getProperties();
            while (properties.hasNext()) {
                conjunction.add(new Assert(properties.next()));
            }
            this.conjunct_ = Cnf.simplify(conjunction);
        }

        @Override
        public void visit(ContainsAny condition) {
            Disjunction disjunction = new Disjunction(new IAssertion[0]);
            Iterator<String> properties = condition.getProperties();
            while (properties.hasNext()) {
                disjunction.add(new Assert(properties.next()));
            }
            this.conjunct_ = Cnf.simplify(disjunction);
        }

        @Override
        public void visit(IConjunct condition) {
            this.conjunct_ = condition;
        }

        @Override
        public void visit(Not condition) {
            Conjunction conjunction = new Conjunction(new IDisjunct[0]);
            Iterator<ICondition> conditions = condition.getConditions();
            while (conditions.hasNext()) {
                IConjunct conjunct = Cnf.negate(Cnf.convert(conditions.next()));
                Iterator<IDisjunct> disjuncts = conjunct.getDisjuncts();
                while (disjuncts.hasNext()) {
                    IDisjunct disjunct = disjuncts.next();
                    if (Cnf.isTautology(disjunct)) continue;
                    conjunction.add(disjunct);
                }
            }
            this.conjunct_ = Cnf.simplify(conjunction);
        }

        @Override
        public void visit(AssertLess condition) {
            this.conjunct_ = condition;
        }

        @Override
        public void visit(AssertMore condition) {
            this.conjunct_ = condition;
        }

        @Override
        public void visit(AssertNotLess condition) {
            this.conjunct_ = condition;
        }

        @Override
        public void visit(AssertNotMore condition) {
            this.conjunct_ = condition;
        }

        @Override
        public void visit(Between condition) {
            this.visit((AllOf)condition);
        }

        @Override
        public void visit(Equals condition) {
            this.visit((AllOf)condition);
        }
    }
}

